/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mailagent;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.mailagent.Encode;
import jp.sourceforge.mailagent.MailAgent;
import jp.sourceforge.mailagent.MailConfig;
import jp.sourceforge.mailagent.MailSource;
import jp.sourceforge.mailagent.ResultMail;
import jp.sourceforge.mailagent.SendmailThread;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

class MailAgentImpl
implements MailAgent {
    private MailConfig config;
    private String mailbody;
    private MailSource mailSource = new MailSource();
    private Template template;
    private Logger logger = Logger.getLogger((String)"mailagent");

    protected MailAgentImpl() {
    }

    @Override
    public void post() {
        SendmailThread sm = new SendmailThread(this.mailSource);
        sm.setSMTP(this.config.getSmtphost(), this.config.isSmtpauth(), this.config.getSmtpuser(), this.config.getSmtppasswd(), this.config.getTimeout());
        sm.setEncode(this.config.getEncode());
        Thread th = new Thread(sm);
        th.start();
    }

    @Override
    public ResultMail send() {
        SendmailThread sm = new SendmailThread(this.mailSource);
        sm.setSMTP(this.config.getSmtphost(), this.config.isSmtpauth(), this.config.getSmtpuser(), this.config.getSmtppasswd(), this.config.getTimeout());
        sm.setEncode(this.config.getEncode());
        return sm.send();
    }

    @Override
    public void setTO(String[] toary) {
        for (int i = 0; i < toary.length; ++i) {
            this.mailSource.setTo(toary[i], null);
        }
    }

    @Override
    public void setTO(Map<String, String> tomap) {
        for (String key : tomap.keySet()) {
            this.mailSource.setTo(key, tomap.get(key));
        }
    }

    @Override
    public void setCC(String[] ccary) {
        for (int i = 0; i < ccary.length; ++i) {
            this.mailSource.setCC(ccary[i], null);
        }
    }

    @Override
    public void setCC(Map<String, String> ccmap) {
        for (String key : ccmap.keySet()) {
            this.mailSource.setCC(key, ccmap.get(key));
        }
    }

    @Override
    public void setBCC(String[] bccary) {
        for (int i = 0; i < bccary.length; ++i) {
            this.mailSource.setBCC(bccary[i], null);
        }
    }

    @Override
    public void setBCC(Map<String, String> bccmap) {
        for (String key : bccmap.keySet()) {
            this.mailSource.setBCC(key, bccmap.get(key));
        }
    }

    @Override
    public void setFROM(String from) {
        this.mailSource.setFrom(from, null);
    }

    @Override
    public void setFROM(String from, String alias) {
        this.mailSource.setFrom(from, alias);
    }

    @Override
    public void setReplyTo(String replyTo) {
        this.mailSource.setReplyto(replyTo);
    }

    @Override
    public void setSubject(String subject) {
        this.mailSource.setSubject(subject);
    }

    @Override
    public void setBody(String body) {
        if (body == null) {
            throw new IllegalArgumentException("\u25c6 mail body is null");
        }
        if (body.length() == 0) {
            throw new IllegalArgumentException("\u25c6 mail body length is 0");
        }
        this.mailSource.setMessage(Encode.convProphibitCode(Encode.convCp932toJIS(body)));
    }

    @Override
    public void setBody(Map<String, Object> map) {
        if (this.template == null) {
            throw new NullPointerException("\u25c6 template not Config");
        }
        this.mailbody = "";
        VelocityContext context = new VelocityContext();
        if (map != null) {
            Set<String> keySet = map.keySet();
            for (String key : keySet) {
                context.put(key, map.get(key));
            }
        }
        try {
            StringWriter sw = new StringWriter();
            this.template.merge((Context)context, (Writer)sw);
            sw.close();
            this.mailbody = Encode.convProphibitCode(Encode.convCp932toJIS(sw.toString()));
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (ParseErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("\u25c6 Exception :" + e.getMessage(), e);
        }
        finally {
            this.mailSource.setMessage(this.mailbody);
        }
    }

    @Override
    public void setTempFiles(File ... temps) {
        this.mailSource.setTemp(temps);
    }

    @Override
    public void clearAll() {
        this.mailSource.clearAll();
    }

    @Override
    public void clearTo() {
        this.mailSource.clearTo();
    }

    @Override
    public String getMessage() {
        return this.mailSource.getMessage();
    }

    @Override
    public void setMailConfig(MailConfig config) {
        this.config = config;
        StringBuffer sb = new StringBuffer();
        sb.append("\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\n");
        sb.append("\t\t\u25a0 --------------- MailAgent init Config ---------------\n");
        sb.append("\t\t\u25a0 SMTP_HOST    = " + this.config.getSmtphost() + "\n");
        sb.append("\t\t\u25a0 TIMEOUT      = " + Integer.toString(this.config.getTimeout()) + " sec" + "\n");
        sb.append("\t\t\u25a0 SMTP_AUTH    = " + this.config.isSmtpauth() + "\n");
        sb.append("\t\t\u25a0 SMTP_USER    = " + this.config.getSmtpuser() + "\n");
        sb.append("\t\t\u25a0 SMTP_PASSWD  = " + this.config.getSmtppasswd() + "\n");
        sb.append("\t\t\u25a0 MAIL_ENCODE  = " + this.config.getEncode() + "\n");
        this.logger.debug((Object)sb.toString());
    }

    @Override
    public void setTemplate(Template template) {
        this.template = template;
    }
}

