/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mailagent;

import java.util.Properties;
import jp.sourceforge.mailagent.MailAgent;
import jp.sourceforge.mailagent.MailAgentImpl;
import jp.sourceforge.mailagent.MailConfig;
import jp.sourceforge.mailagent.TemplateConfig;
import org.apache.log4j.Logger;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;

public final class MailAgentBuilder {
    private MailConfig config;
    private TemplateConfig templateConfig;

    public MailAgentBuilder(MailConfig config) {
        this.config = config;
    }

    public MailAgentBuilder(MailConfig config, TemplateConfig templateConfig) {
        this.config = config;
        this.templateConfig = templateConfig;
    }

    public MailAgent create() {
        return this.create(null);
    }

    public MailAgent create(String templateName) {
        MailAgentImpl mailAgent = new MailAgentImpl();
        mailAgent.setMailConfig(this.config);
        if (templateName == null && this.templateConfig == null) {
            return mailAgent;
        }
        if (templateName != null && this.templateConfig != null) {
            return this.setTemplate(mailAgent, this.templateConfig, templateName);
        }
        if (templateName == null && this.templateConfig != null) {
            throw new RuntimeException("\u25c6 templateName is NULL");
        }
        throw new RuntimeException("\u25c6 TemplateConfig is NULL");
    }

    private MailAgent setTemplate(MailAgent mailAgent, TemplateConfig templateConfig, String templateName) {
        Properties prop = new Properties();
        prop.setProperty("resource.loader", "file,class");
        prop.setProperty("file.resource.loader.class", FileResourceLoader.class.getName());
        prop.setProperty("file.resource.loader.path", templateConfig.getTemplateLoadpath());
        prop.setProperty("class.resource.loader.class", ClasspathResourceLoader.class.getName());
        prop.setProperty("input.encoding", templateConfig.getTemplateInEncode());
        prop.setProperty("output.encoding", templateConfig.getTemplateOutEncode());
        prop.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
        VelocityEngine engine = new VelocityEngine();
        try {
            engine.init(prop);
            StringBuffer sb = new StringBuffer();
            sb.append("\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\n");
            sb.append("\t\t\u25a0 --------------- Velocity init  ---------------\n");
            sb.append("\t\t\u25a0 resource.loader             = " + engine.getProperty("resource.loader") + "\n");
            sb.append("\t\t\u25a0 file.resource.loader.class  = " + engine.getProperty("file.resource.loader.class") + "\n");
            sb.append("\t\t\u25a0 file.resource.loader.path   = " + engine.getProperty("file.resource.loader.path") + "\n");
            sb.append("\t\t\u25a0 class.resource.loader.class = " + engine.getProperty("class.resource.loader.class") + "\n");
            sb.append("\t\t\u25a0 input.encoding   = " + engine.getProperty("input.encoding") + "\n");
            sb.append("\t\t\u25a0 output.encoding  = " + engine.getProperty("output.encoding") + "\n");
            sb.append("\t\t\u25a0 runtime.log.logsystem.class = " + engine.getProperty("runtime.log.logsystem.class") + "\n");
            Logger logger = Logger.getLogger((String)"mailagent");
            logger.debug((Object)sb.toString());
            logger.debug((Object)("\u25a0 template set = " + templateName));
            mailAgent.setTemplate(engine.getTemplate(templateName));
            return mailAgent;
        }
        catch (Exception e) {
            throw new RuntimeException("\u25c6 Velocity init error Exception : " + e.getMessage(), e);
        }
    }
}

