/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.SecurityAssociationActions;
import org.jboss.security.SimplePrincipal;

public class ClientLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Principal loginPrincipal;
    private Object loginCredential;
    private Map sharedState;
    private boolean useFirstPass;
    private boolean restoreLoginIdentity;
    private Principal restorePrincipal;
    private Object restoreCredential;
    private Subject restoreSubject;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        String flag = (String)options.get("multi-threaded");
        if (Boolean.valueOf(flag).booleanValue()) {
            SecurityAssociationActions.setServer();
        }
        flag = (String)options.get("restore-login-identity");
        this.restoreLoginIdentity = Boolean.valueOf(flag);
        String passwordStacking = (String)options.get("password-stacking");
        this.useFirstPass = passwordStacking != null;
    }

    public boolean login() throws LoginException {
        if (this.restoreLoginIdentity) {
            this.restorePrincipal = SecurityAssociationActions.getPrincipal();
            this.restoreCredential = SecurityAssociationActions.getCredential();
            this.restoreSubject = SecurityAssociationActions.getSubject();
        }
        if (this.useFirstPass) {
            try {
                Object name = this.sharedState.get("javax.security.auth.login.name");
                if (!(name instanceof Principal)) {
                    String username = name != null ? name.toString() : "";
                    this.loginPrincipal = new SimplePrincipal(username);
                } else {
                    this.loginPrincipal = (Principal)name;
                }
                this.loginCredential = this.sharedState.get("javax.security.auth.login.password");
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        NameCallback nc = new NameCallback("User name: ", "guest");
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            char[] password = null;
            this.callbackHandler.handle(callbacks);
            String username = nc.getName();
            this.loginPrincipal = new SimplePrincipal(username);
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                password = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, password, 0, tmpPassword.length);
                pc.clearPassword();
            }
            this.loginCredential = password;
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + ", not able to use this callback for username/password");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        SecurityAssociationActions.setPrincipalInfo(this.loginPrincipal, this.loginCredential, this.subject);
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.loginPrincipal)) {
            principals.add(this.loginPrincipal);
        }
        return true;
    }

    public boolean abort() throws LoginException {
        SecurityAssociationActions.clear();
        if (this.restoreLoginIdentity) {
            SecurityAssociationActions.setPrincipalInfo(this.restorePrincipal, this.restoreCredential, this.restoreSubject);
        }
        return true;
    }

    public boolean logout() throws LoginException {
        SecurityAssociationActions.clear();
        if (this.restoreLoginIdentity) {
            SecurityAssociationActions.setPrincipalInfo(this.restorePrincipal, this.restoreCredential, this.restoreSubject);
        }
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(this.loginPrincipal);
        return true;
    }
}

