/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ejb.AbstractEntityManagerImpl;

public class TransactionImpl
implements EntityTransaction {
    private AbstractEntityManagerImpl entityManager;
    private Transaction tx;

    public TransactionImpl(AbstractEntityManagerImpl entityManager) {
        this.entityManager = entityManager;
    }

    private Session getSession() {
        return this.entityManager.getSession();
    }

    public void begin() {
        if (this.tx != null && this.tx.isActive()) {
            throw new IllegalStateException("Transaction already active");
        }
        this.entityManager.adjustFlushMode();
        this.tx = this.getSession().beginTransaction();
    }

    public void commit() {
        if (this.tx == null || !this.tx.isActive()) {
            throw new IllegalStateException("Transaction not active");
        }
        this.tx.commit();
        this.entityManager.adjustFlushMode();
    }

    public void rollback() {
        if (this.tx == null || !this.tx.isActive()) {
            throw new IllegalStateException("Transaction not active");
        }
        try {
            this.tx.rollback();
            this.entityManager.adjustFlushMode();
        }
        catch (RuntimeException e) {
            throw new PersistenceException("unexpected error when rollbacking", (Throwable)e);
        }
    }

    public boolean isActive() {
        try {
            return this.tx != null && this.tx.isActive();
        }
        catch (RuntimeException e) {
            throw new PersistenceException("unexpected error when checking transaction status", (Throwable)e);
        }
    }
}

