/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.SerializationException;

public final class SerializationHelper {
    private static final Log log = LogFactory.getLog((Class)SerializationHelper.class);

    private SerializationHelper() {
    }

    public static Object clone(Serializable object) throws SerializationException {
        log.trace((Object)"Starting clone through serialization");
        return SerializationHelper.deserialize(SerializationHelper.serialize(object));
    }

    public static void serialize(Serializable obj, OutputStream outputStream) throws SerializationException {
        if (outputStream == null) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Starting serialization of object [" + obj + "]"));
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(outputStream);
            out.writeObject(obj);
        }
        catch (IOException ex) {
            throw new SerializationException("could not serialize", ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    public static byte[] serialize(Serializable obj) throws SerializationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        SerializationHelper.serialize(obj, baos);
        return baos.toByteArray();
    }

    public static Object deserialize(InputStream inputStream) throws SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        log.trace((Object)"Starting deserialization of object");
        CustomObjectInputStream in = null;
        try {
            in = new CustomObjectInputStream(inputStream);
            Object object = in.readObject();
            return object;
        }
        catch (ClassNotFoundException ex) {
            throw new SerializationException("could not deserialize", ex);
        }
        catch (IOException ex) {
            throw new SerializationException("could not deserialize", ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public static Object deserialize(byte[] objectData) throws SerializationException {
        if (objectData == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        return SerializationHelper.deserialize(bais);
    }

    private static final class CustomObjectInputStream
    extends ObjectInputStream {
        public CustomObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            String className = v.getName();
            Class<?> resolvedClass = null;
            log.trace((Object)("Attempting to locate class [" + className + "]"));
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                resolvedClass = loader.loadClass(className);
                log.trace((Object)"Class resolved through context class loader");
            }
            catch (ClassNotFoundException e) {
                log.trace((Object)"Asking super to resolve");
                resolvedClass = super.resolveClass(v);
            }
            return resolvedClass;
        }
    }
}

