/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ReplicationMode;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.type.CollectionType;

public abstract class CascadingAction {
    private static final Log log = LogFactory.getLog((Class)CascadingAction.class);
    public static final CascadingAction DELETE = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to delete: " + entityName));
            }
            if (ForeignKeys.isNotTransient(entityName, child, null, session)) {
                session.delete(entityName, child, isCascadeDeleteEnabled);
            }
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingAction.getAllElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return true;
        }

        public String toString() {
            return "ACTION_DELETE";
        }
    };
    public static final CascadingAction LOCK = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to lock: " + entityName));
            }
            session.lock(entityName, child, LockMode.NONE);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 2.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_LOCK";
        }
    };
    public static final CascadingAction REFRESH = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to refresh: " + entityName));
            }
            session.refresh(child, (Map)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 3.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_REFRESH";
        }
    };
    public static final CascadingAction EVICT = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to evict: " + entityName));
            }
            session.evict(child);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 4.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_EVICT";
        }
    };
    public static final CascadingAction SAVE_UPDATE = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to saveOrUpdate: " + entityName));
            }
            session.saveOrUpdate(entityName, child);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 5.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return true;
        }

        public String toString() {
            return "ACTION_SAVE_UPDATE";
        }
    };
    public static final CascadingAction MERGE = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to merge: " + entityName));
            }
            session.merge(entityName, child, (Map)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 6.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_MERGE";
        }
    };
    public static final CascadingAction SAVE_UPDATE_COPY = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to saveOrUpdateCopy: " + entityName));
            }
            session.saveOrUpdateCopy(entityName, child, (Map)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 7.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_SAVE_UPDATE_COPY";
        }
    };
    public static final CascadingAction PERSIST = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to persist: " + entityName));
            }
            session.persist(entityName, child, (Map)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingAction.getAllElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_PERSIST";
        }
    };
    public static final CascadingAction PERSIST_ON_FLUSH = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to persistOnFlush: " + entityName));
            }
            session.persistOnFlush(entityName, child, (Map)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingAction.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return true;
        }

        public String toString() {
            return "ACTION_PERSIST_ON_FLUSH";
        }
    };
    public static final CascadingAction REPLICATE = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to replicate: " + entityName));
            }
            session.replicate(entityName, child, (ReplicationMode)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 10.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_REPLICATE";
        }
    };

    public abstract void cascade(EventSource var1, Object var2, String var3, Object var4, boolean var5) throws HibernateException;

    public abstract Iterator getCascadableChildrenIterator(EventSource var1, CollectionType var2, Object var3);

    public abstract boolean deleteOrphans();

    CascadingAction() {
    }

    private static Iterator getAllElementsIterator(EventSource session, CollectionType collectionType, Object collection) {
        return collectionType.getElementsIterator(collection, session);
    }

    public static Iterator getLoadedElementsIterator(SessionImplementor session, CollectionType collectionType, Object collection) {
        if (CascadingAction.collectionIsInitialized(collection)) {
            return collectionType.getElementsIterator(collection, session);
        }
        return ((PersistentCollection)collection).queuedAdditionIterator();
    }

    private static boolean collectionIsInitialized(Object collection) {
        return !(collection instanceof PersistentCollection) || ((PersistentCollection)collection).wasInitialized();
    }
}

