/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.aop.Advised;
import org.jboss.aop.util.MarshalledValue;
import org.jboss.aspects.versioned.OptimisticLockFailure;
import org.jboss.tm.TransactionLocal;

public class VersionedObject {
    FIFOSemaphore lock = new FIFOSemaphore(1L);
    TransactionLocal txLocal = new TransactionLocal();
    long currentId = 0L;
    Object currentObject;
    long versionIdGenerator = 0L;

    public VersionedObject(Object obj) {
        this.currentObject = obj;
    }

    public Object getVersion(Transaction tx) {
        if (tx == null) {
            return this.currentObject;
        }
        return this.txLocal.get(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createVersion(Transaction tx) throws Exception {
        long versionId;
        this.lock.acquire();
        Object version = null;
        try {
            version = new MarshalledValue(this.currentObject).get();
            if (version instanceof Advised) {
                Advised versionAdvised = (Advised)version;
                Advised currentAdvised = (Advised)this.currentObject;
                versionAdvised._setInstanceAdvisor(currentAdvised._getInstanceAdvisor());
            }
            versionId = ++this.versionIdGenerator;
        }
        finally {
            this.lock.release();
        }
        tx.registerSynchronization((Synchronization)new VersionSynchronization(tx, versionId, version));
        this.txLocal.set(tx, version);
        return version;
    }

    private final class VersionSynchronization
    implements Synchronization {
        long versionId;
        Object version;
        Transaction tx;

        public VersionSynchronization(Transaction tx, long versionId, Object version) {
            this.tx = tx;
            this.versionId = versionId;
            this.version = version;
        }

        public void beforeCompletion() {
            try {
                VersionedObject.this.lock.acquire();
            }
            catch (InterruptedException ignored) {
                throw new RuntimeException(ignored);
            }
            if (VersionedObject.this.currentId >= this.versionId) {
                VersionedObject.this.lock.release();
                throw new OptimisticLockFailure();
            }
        }

        public void afterCompletion(int status) {
            if (status != 4) {
                VersionedObject.this.currentId = this.versionId;
                VersionedObject.this.currentObject = this.version;
                VersionedObject.this.lock.release();
            }
        }
    }
}

