/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.gui;

import de.java2html.JavaSourceConversionSettings;
import de.java2html.converter.IJavaSourceConverter;
import de.java2html.gui.IStatisticsView;
import de.java2html.gui.Java2HtmlOptionsPanel;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.util.Ensure;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DirectTextConversionPanel {
    private final JComponent content;
    private static final Font FONT = new Font("Monospaced", 0, 11);
    private final JTextArea taInput;
    private final JTextArea taOutput;
    private final JTextField tfTitle;
    private final Java2HtmlOptionsPanel optionsPanel;
    private final IStatisticsView statisticsView;

    public DirectTextConversionPanel(Java2HtmlOptionsPanel optionsPanel, IStatisticsView statisticsView) {
        Ensure.ensureArgumentNotNull(optionsPanel);
        Ensure.ensureArgumentNotNull(statisticsView);
        this.statisticsView = statisticsView;
        this.optionsPanel = optionsPanel;
        JLabel l1 = new JLabel("Title (optional):");
        this.tfTitle = new JTextField(30);
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                DirectTextConversionPanel.this.convert();
            }

            public void removeUpdate(DocumentEvent e) {
                DirectTextConversionPanel.this.convert();
            }

            public void insertUpdate(DocumentEvent e) {
                DirectTextConversionPanel.this.convert();
            }
        };
        this.tfTitle.getDocument().addDocumentListener(documentListener);
        this.taInput = new JTextArea(10, 80);
        this.taInput.getDocument().addDocumentListener(documentListener);
        this.taInput.setFont(FONT);
        this.taOutput = new JTextArea(10, 80);
        this.taOutput.setEditable(false);
        this.taOutput.setFont(FONT);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(5, 6, 5, 6));
        GridBagConstraints twoColumnLineConstraints = new GridBagConstraints();
        twoColumnLineConstraints.anchor = 17;
        twoColumnLineConstraints.gridx = 0;
        twoColumnLineConstraints.gridwidth = 2;
        twoColumnLineConstraints.fill = 2;
        twoColumnLineConstraints.weightx = 1.0;
        twoColumnLineConstraints.insets = new Insets(6, 2, 2, 2);
        GridBagConstraints twoColumnBlockConstraints = new GridBagConstraints();
        twoColumnBlockConstraints.anchor = 17;
        twoColumnBlockConstraints.gridx = 0;
        twoColumnBlockConstraints.gridwidth = 2;
        twoColumnBlockConstraints.fill = 1;
        twoColumnBlockConstraints.weightx = 1.0;
        twoColumnBlockConstraints.weighty = 1.0;
        twoColumnBlockConstraints.insets = new Insets(2, 2, 2, 2);
        GridBagConstraints leftColumnConstraints = new GridBagConstraints();
        leftColumnConstraints.insets = new Insets(2, 2, 2, 2);
        leftColumnConstraints.gridx = 0;
        leftColumnConstraints.anchor = 13;
        GridBagConstraints rightColumnConstraints = new GridBagConstraints();
        rightColumnConstraints.insets = new Insets(2, 2, 2, 2);
        rightColumnConstraints.gridx = 1;
        rightColumnConstraints.fill = 2;
        rightColumnConstraints.anchor = 17;
        panel.add((Component)l1, leftColumnConstraints);
        panel.add((Component)this.tfTitle, rightColumnConstraints);
        panel.add((Component)new JLabel("Java source (paste your source code here):"), twoColumnLineConstraints);
        panel.add((Component)new JScrollPane(this.taInput), twoColumnBlockConstraints);
        panel.add((Component)new JLabel("Converted source (copy and paste this to where you want it):"), twoColumnLineConstraints);
        panel.add((Component)new JScrollPane(this.taOutput), twoColumnBlockConstraints);
        optionsPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DirectTextConversionPanel.this.convert();
            }
        });
        this.content = panel;
    }

    public JComponent getContent() {
        return this.content;
    }

    private void convert() {
        String input;
        String title = this.tfTitle.getText();
        if (title.equals("")) {
            title = null;
        }
        if ((input = this.taInput.getText()).trim().equals("")) {
            this.taOutput.setText("");
            this.statisticsView.setStatistics(null);
            return;
        }
        JavaSourceConversionSettings settings = this.optionsPanel.getConversionSettings();
        settings.getConversionOptions().setShowJava2HtmlLink(true);
        JavaSourceParser parser = new JavaSourceParser(settings.getConversionOptions());
        JavaSource source = parser.parse(input);
        source.setFileName(title);
        IJavaSourceConverter converter = settings.createConverter();
        StringWriter writer = new StringWriter();
        try {
            converter.writeDocumentHeader(writer, settings.getConversionOptions(), title);
            converter.convert(source, settings.getConversionOptions(), writer);
            converter.writeDocumentFooter(writer, settings.getConversionOptions());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.taOutput.setText(writer.toString());
        this.statisticsView.setStatistics(source.getStatistic());
        this.taOutput.selectAll();
    }

    public void requestFocus() {
        this.taInput.requestFocus();
    }
}

