package trail.entity.update;

import trail.entity.beans.*;
import javax.ejb.*;
import javax.persistence.*;
import javax.annotation.Resource;
import java.util.*;

@Stateless
public class UpdateCalculator implements Calculator {

  @PersistenceContext
  protected EntityManager em;

  public Collection <TimedRecord> getRecords () {
    return em.createQuery("from TimedRecord r order by r.id desc").getResultList();
  }

  public void updateExchangeRate (double newrate) {
    Collection <TimedRecord> rc = em.createQuery("from TimedRecord r").getResultList();
    for (Iterator iter = rc.iterator(); iter.hasNext();) {
      TimedRecord r = (TimedRecord) iter.next();
      r.setSaving(r.getSaving() * newrate);
      r.setResult(r.getResult() * newrate);
    }
    // em.flush();
  }
}
