/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.gui;

import de.java2html.JavaSourceConversionSettings;
import de.java2html.converter.IJavaSourceConverter;
import de.java2html.converter.JavaSourceConverterProvider;
import de.java2html.gui.AbstractSimpleListCellRenderer;
import de.java2html.options.HorizontalAlignment;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.options.JavaSourceStyleTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Java2HtmlOptionsPanel {
    private static final JavaSourceStyleTable[] styles = JavaSourceStyleTable.getPredefinedTables();
    private static final HorizontalAlignment[] alignments = new HorizontalAlignment[]{HorizontalAlignment.LEFT, HorizontalAlignment.CENTER, HorizontalAlignment.RIGHT};
    private final SpinnerNumberModel tabModel = new SpinnerNumberModel(2, 0, 16, 1);
    private final JSpinner chTab;
    private final JComboBox chTarget;
    private final JComboBox chStyle;
    private final JComboBox chAlignment;
    private final JCheckBox cbShowLineNumbers;
    private final JCheckBox cbShowTableBorder;
    private final List listeners = new ArrayList();
    private final JComponent content;

    public Java2HtmlOptionsPanel() {
        this.chTab = new JSpinner(this.tabModel);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Java2HtmlOptionsPanel.this.fireStateChanged();
            }
        };
        this.tabModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Java2HtmlOptionsPanel.this.fireStateChanged();
            }
        });
        this.chTarget = new JComboBox<IJavaSourceConverter>(JavaSourceConverterProvider.getAllConverters());
        this.chTarget.setRenderer(new AbstractSimpleListCellRenderer(){

            protected String getLabel(Object value) {
                IJavaSourceConverter converter = (IJavaSourceConverter)value;
                return converter.getMetaData().getPrintName();
            }
        });
        this.chTarget.addItemListener(itemListener);
        this.chStyle = new JComboBox<JavaSourceStyleTable>(styles);
        this.chStyle.setRenderer(new AbstractSimpleListCellRenderer(){

            protected String getLabel(Object value) {
                JavaSourceStyleTable table = (JavaSourceStyleTable)value;
                return table.getName();
            }
        });
        this.chStyle.addItemListener(itemListener);
        this.chAlignment = new JComboBox<HorizontalAlignment>(alignments);
        this.chAlignment.setRenderer(new AbstractSimpleListCellRenderer(){

            protected String getLabel(Object value) {
                HorizontalAlignment alignment = (HorizontalAlignment)value;
                return alignment.getName();
            }
        });
        this.chAlignment.addItemListener(itemListener);
        this.cbShowLineNumbers = new JCheckBox("Line numbers", true);
        this.cbShowLineNumbers.addItemListener(itemListener);
        this.cbShowTableBorder = new JCheckBox("Table border", true);
        this.cbShowTableBorder.addItemListener(itemListener);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints leftColumnConstraints = new GridBagConstraints();
        leftColumnConstraints.insets = new Insets(2, 2, 2, 2);
        leftColumnConstraints.gridx = 0;
        leftColumnConstraints.anchor = 13;
        GridBagConstraints rightColumnConstraints = new GridBagConstraints();
        rightColumnConstraints.insets = new Insets(2, 2, 2, 2);
        rightColumnConstraints.gridx = 1;
        rightColumnConstraints.fill = 0;
        rightColumnConstraints.anchor = 17;
        GridBagConstraints twoColumnConstraints = new GridBagConstraints();
        twoColumnConstraints.insets = new Insets(2, 2, 2, 2);
        twoColumnConstraints.gridx = 0;
        twoColumnConstraints.gridwidth = 2;
        twoColumnConstraints.anchor = 17;
        panel.add((Component)new JLabel("Target:"), leftColumnConstraints);
        panel.add((Component)this.chTarget, rightColumnConstraints);
        panel.add((Component)new JLabel("Style:"), leftColumnConstraints);
        panel.add((Component)this.chStyle, rightColumnConstraints);
        panel.add((Component)new JLabel("Tab-space:"), leftColumnConstraints);
        panel.add((Component)this.chTab, rightColumnConstraints);
        panel.add((Component)new JLabel("Alignment:"), leftColumnConstraints);
        panel.add((Component)this.chAlignment, rightColumnConstraints);
        panel.add((Component)this.cbShowLineNumbers, twoColumnConstraints);
        panel.add((Component)this.cbShowTableBorder, twoColumnConstraints);
        this.content = panel;
        this.initDefaultOptions();
    }

    public JComponent getContent() {
        return this.content;
    }

    private void initDefaultOptions() {
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        this.tabModel.setValue(new Integer(options.getTabSize()));
        this.chStyle.setSelectedItem(options.getStyleTable());
        this.cbShowLineNumbers.setSelected(options.isShowLineNumbers());
        this.cbShowTableBorder.setSelected(options.isShowTableBorder());
        this.chAlignment.setSelectedItem(options.getHorizontalAlignment());
    }

    public JavaSourceConversionSettings getConversionSettings() {
        IJavaSourceConverter selectedConverter = JavaSourceConverterProvider.getAllConverters()[this.chTarget.getSelectedIndex()];
        String converterName = selectedConverter.getMetaData().getName();
        return new JavaSourceConversionSettings(this.getConversionOptions(), converterName);
    }

    private JavaSourceConversionOptions getConversionOptions() {
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        int tabs = this.tabModel.getNumber().intValue();
        options.setTabSize(tabs);
        options.setStyleTable(styles[this.chStyle.getSelectedIndex()]);
        options.setShowLineNumbers(this.cbShowLineNumbers.isSelected());
        options.setShowTableBorder(this.cbShowTableBorder.isSelected());
        options.setHorizontalAlignment(alignments[this.chAlignment.getSelectedIndex()]);
        return options;
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        Iterator iter = new ArrayList(this.listeners).iterator();
        while (iter.hasNext()) {
            ChangeListener listener = (ChangeListener)iter.next();
            listener.stateChanged(event);
        }
    }
}

