/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.commandline;

import de.java2html.commandline.CommandlineArguments;
import de.java2html.commandline.IJava2HtmlConversion;
import de.java2html.commandline.IllegalCommandlineParametersException;
import de.java2html.commandline.Java2HtmlDirectoryConversion;
import de.java2html.commandline.Java2HtmlFileConversion;
import de.java2html.converter.IJavaSourceConverter;
import de.java2html.converter.JavaSourceConverterProvider;
import de.java2html.options.ConversionOptionsUtilities;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.options.JavaSourceStyleTable;
import java.io.File;

public class Java2HtmlCommandline {
    private static final String PARAM_TARGETFILE = "targetfile";
    private static final String PARAM_SRCFILE = "srcfile";
    private static final String PARAM_STYLE = "style";
    private static final String FLAG_COPYTOTARGETUNPROCESSEDFILES = "copytotargetunprocessedfiles";
    private static final String PARAM_TABS = "tabs";
    private static final String PARAM_CONVERTER = "converter";
    private static final String PARAM_TARGETDIR = "targetdir";
    private static final String PARAM_SRCDIR = "srcdir";
    private static final String PARAM_FILEMASK = "filemask";
    private static final String DEFAULT_CONVERTER_TYPE_NAME = "HTML";
    private static final String DEFAULT_FILEMASK = "*.java";

    public static IJava2HtmlConversion createCommandlineConversion(String[] args) throws IllegalCommandlineParametersException {
        CommandlineArguments arguments = new CommandlineArguments(args);
        if (arguments.isParameterSet(PARAM_SRCDIR)) {
            return Java2HtmlCommandline.createDirectoryConversion(arguments);
        }
        if (arguments.isParameterSet(PARAM_SRCFILE)) {
            return Java2HtmlCommandline.createFileConversion(arguments);
        }
        throw new IllegalCommandlineParametersException("No parameter -srcdir or -srcfile specified.");
    }

    private static IJava2HtmlConversion createFileConversion(CommandlineArguments arguments) throws IllegalCommandlineParametersException {
        arguments.assertContainsNoUnsupportedFlags(new String[0]);
        arguments.assertContainsNoUnsupportedParameters(new String[]{PARAM_SRCFILE, PARAM_TARGETFILE, PARAM_CONVERTER, PARAM_TABS, PARAM_STYLE});
        String srcFileName = arguments.getRequiredParameterStringValue(PARAM_SRCFILE);
        String targetFileName = arguments.getParameterStringValue(PARAM_TARGETFILE, null);
        String converterType = arguments.getParameterStringValue(PARAM_CONVERTER, DEFAULT_CONVERTER_TYPE_NAME);
        int tabSize = arguments.getParameterPositiveIntValue(PARAM_TABS, JavaSourceConversionOptions.getDefault().getTabSize());
        String styleName = arguments.getParameterStringValue(PARAM_STYLE, JavaSourceStyleTable.getDefault().getName());
        IJavaSourceConverter converter = Java2HtmlCommandline.getConverter(converterType);
        if (converter == null) {
            System.err.println("ERROR: Unknown converter type: " + converterType);
            Java2HtmlCommandline.printUsage();
            System.exit(1);
        }
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        Java2HtmlCommandline.applyStyle(styleName, options);
        options.setTabSize(tabSize);
        return new Java2HtmlFileConversion(new File(srcFileName), targetFileName == null ? null : new File(targetFileName), converter, options);
    }

    private static IJava2HtmlConversion createDirectoryConversion(CommandlineArguments arguments) throws IllegalCommandlineParametersException {
        arguments.assertContainsNoUnsupportedFlags(new String[]{FLAG_COPYTOTARGETUNPROCESSEDFILES});
        arguments.assertContainsNoUnsupportedParameters(new String[]{PARAM_SRCDIR, PARAM_TARGETDIR, PARAM_CONVERTER, PARAM_TABS, PARAM_STYLE, PARAM_FILEMASK});
        String srcDirectoryName = arguments.getRequiredParameterStringValue(PARAM_SRCDIR);
        String targetDirectoryName = arguments.getParameterStringValue(PARAM_TARGETDIR, null);
        String converterType = arguments.getParameterStringValue(PARAM_CONVERTER, DEFAULT_CONVERTER_TYPE_NAME);
        int tabSize = arguments.getParameterPositiveIntValue(PARAM_TABS, JavaSourceConversionOptions.getDefault().getTabSize());
        boolean copyUnprocessedFiles = arguments.isFlagSet(FLAG_COPYTOTARGETUNPROCESSEDFILES);
        String styleName = arguments.getParameterStringValue(PARAM_STYLE, JavaSourceStyleTable.getDefault().getName());
        String fileMask = arguments.getParameterStringValue(PARAM_FILEMASK, DEFAULT_FILEMASK);
        IJavaSourceConverter converter = Java2HtmlCommandline.getConverter(converterType);
        if (converter == null) {
            System.err.println("ERROR: Unknown converter type: " + converterType);
            Java2HtmlCommandline.printUsage();
            System.exit(1);
        }
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        Java2HtmlCommandline.applyStyle(styleName, options);
        options.setTabSize(tabSize);
        return new Java2HtmlDirectoryConversion(new File(srcDirectoryName), converter, targetDirectoryName == null ? null : new File(targetDirectoryName), fileMask, copyUnprocessedFiles, options);
    }

    public static void printUsage() {
        System.out.println("\nValid usage: \n");
        System.out.println("1. To convert a directory including subdirectories: \n");
        System.out.println("\tjava -jar java2html.jar -srcdir d:/src [-targetdir d:/src/output] [-filemask *.java] [-converter " + Java2HtmlCommandline.getValidConverterNames() + "] [-" + PARAM_TABS + " 4] [-" + FLAG_COPYTOTARGETUNPROCESSEDFILES + "] -" + PARAM_STYLE + " [ " + Java2HtmlCommandline.getValidStylesAsString() + " ]\n");
        System.out.println("2. To convert a single file: \n");
        System.out.println("\tjava -jar java2html.jar -srcfile d:/src/test.java [-targetfile d:/src/output/target.java]  [-converter " + Java2HtmlCommandline.getValidConverterNames() + "] [-" + PARAM_TABS + " 8]" + " -" + PARAM_STYLE + " [ " + Java2HtmlCommandline.getValidStylesAsString() + " ]\n");
    }

    private static void applyStyle(String styleName, JavaSourceConversionOptions options) throws IllegalCommandlineParametersException {
        JavaSourceStyleTable styleTable = JavaSourceStyleTable.getPredefinedTable(styleName);
        if (styleTable == null) {
            throw new IllegalCommandlineParametersException("Unknown style '" + styleName + "'");
        }
        options.setStyleTable(styleTable);
    }

    private static String getValidStylesAsString() {
        return ConversionOptionsUtilities.getSeparatedString(ConversionOptionsUtilities.getPredefinedStyleTableNames(), " | ");
    }

    private static String getValidConverterNames() {
        return ConversionOptionsUtilities.getSeparatedString(JavaSourceConverterProvider.getAllConverterNames(), " | ");
    }

    private static IJavaSourceConverter getConverter(String converterType) throws IllegalCommandlineParametersException {
        IJavaSourceConverter converter = JavaSourceConverterProvider.getJavaSourceConverterByName(converterType);
        if (converter == null) {
            throw new IllegalCommandlineParametersException("Unsupported converter type '" + converterType + "'");
        }
        return converter;
    }
}

