/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.TransactionRequiredException;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.ejb.HibernateEntityManagerImplementor;
import org.hibernate.ejb.QueryImpl;
import org.hibernate.ejb.TransactionImpl;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityManagerImpl
implements HibernateEntityManagerImplementor,
Serializable {
    private static Log log = LogFactory.getLog(AbstractEntityManagerImpl.class);
    protected transient TransactionImpl tx = new TransactionImpl(this);
    protected PersistenceContextType persistenceContextType;
    private FlushModeType flushMode = FlushModeType.AUTO;
    private PersistenceUnitTransactionType transactionType;

    protected AbstractEntityManagerImpl(PersistenceContextType type, PersistenceUnitTransactionType transactionType) {
        this.persistenceContextType = type;
        this.transactionType = transactionType;
    }

    public javax.persistence.Query createQuery(String ejbqlString) {
        this.adjustFlushMode();
        return new QueryImpl(this.getSession().createQuery(ejbqlString));
    }

    public javax.persistence.Query createNamedQuery(String name) {
        this.adjustFlushMode();
        return new QueryImpl(this.getSession().getNamedQuery(name));
    }

    public javax.persistence.Query createNativeQuery(String sqlString) {
        this.adjustFlushMode();
        SQLQuery q = this.getSession().createSQLQuery(sqlString);
        return new QueryImpl((Query)q);
    }

    public javax.persistence.Query createNativeQuery(String sqlString, Class resultClass) {
        this.adjustFlushMode();
        SQLQuery q = this.getSession().createSQLQuery(sqlString);
        q.addEntity("alias1", resultClass.getName(), LockMode.READ);
        return new QueryImpl((Query)q);
    }

    public javax.persistence.Query createNativeQuery(String sqlString, String resultSetMapping) {
        this.adjustFlushMode();
        SQLQuery q = this.getSession().createSQLQuery(sqlString);
        q.setResultSetMapping(resultSetMapping);
        return new QueryImpl((Query)q);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        this.adjustFlushMode();
        try {
            Object rtn = this.getSession().load(entityClass, (Serializable)primaryKey);
            return (T)rtn;
        }
        catch (ObjectNotFoundException e) {
            throw new EntityNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public <A> A find(Class<A> entityClass, Object primaryKey) {
        this.adjustFlushMode();
        try {
            Object rtn = this.getSession().get(entityClass, (Serializable)primaryKey);
            return (A)rtn;
        }
        catch (ObjectNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private void checkTransactionNeeded() {
        if (!this.isTransactionInProgress() && this.persistenceContextType == PersistenceContextType.TRANSACTION) {
            throw new TransactionRequiredException("no transaction is in progress for a TRANSACTION type persistence context");
        }
    }

    public void persist(Object entity) {
        this.checkTransactionNeeded();
        this.adjustFlushMode();
        try {
            this.getSession().persist(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public <A> A merge(A entity) {
        this.checkTransactionNeeded();
        this.adjustFlushMode();
        try {
            return (A)this.getSession().merge(entity);
        }
        catch (StaleObjectStateException sse) {
            throw new IllegalArgumentException(sse);
        }
        catch (ObjectDeletedException sse) {
            throw new IllegalArgumentException(sse);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void remove(Object entity) {
        this.checkTransactionNeeded();
        this.adjustFlushMode();
        try {
            this.getSession().delete(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void refresh(Object entity) {
        this.checkTransactionNeeded();
        this.adjustFlushMode();
        try {
            this.getSession().refresh(entity);
        }
        catch (UnresolvableObjectException uoe) {
            throw new EntityNotFoundException((Throwable)uoe);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public boolean contains(Object entity) {
        try {
            if (entity != null && !(entity instanceof HibernateProxy) && this.getSession().getSessionFactory().getClassMetadata(entity.getClass()) == null) {
                throw new IllegalArgumentException("Not an entity:" + entity.getClass());
            }
            return this.getSession().contains(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void flush() {
        if (!this.isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress");
        }
        this.adjustFlushMode();
        this.getSession().flush();
    }

    @Override
    public abstract Session getSession();

    public EntityTransaction getTransaction() {
        return this.tx;
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
        if (flushMode == FlushModeType.AUTO) {
            this.getSession().setFlushMode(FlushMode.AUTO);
        } else if (flushMode == FlushModeType.COMMIT) {
            this.getSession().setFlushMode(FlushMode.COMMIT);
        } else {
            throw new AssertionFailure("Unknown FlushModeType: " + flushMode);
        }
    }

    public void clear() {
        this.adjustFlushMode();
        this.getSession().clear();
    }

    public FlushModeType getFlushMode() {
        FlushMode mode = this.getSession().getFlushMode();
        if (mode == FlushMode.AUTO) {
            this.flushMode = FlushModeType.AUTO;
        } else if (mode == FlushMode.COMMIT) {
            this.flushMode = FlushModeType.COMMIT;
        } else {
            if (mode == FlushMode.NEVER) {
                if (PersistenceContextType.EXTENDED == this.persistenceContextType && !this.getTransaction().isActive()) {
                    return this.flushMode;
                }
                return null;
            }
            return null;
        }
        return this.flushMode;
    }

    public void lock(Object entity, LockModeType lockMode) {
        if (!this.isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress");
        }
        this.adjustFlushMode();
        if (!this.contains(entity)) {
            throw new IllegalArgumentException("entity not in the persistence context");
        }
        this.getSession().lock(entity, this.getLockMode(lockMode));
    }

    private LockMode getLockMode(LockModeType lockMode) {
        switch (lockMode) {
            case READ: {
                return LockMode.UPGRADE;
            }
            case WRITE: {
                log.warn((Object)"LockModeType.WRITE does not increment the version number");
                return LockMode.UPGRADE;
            }
        }
        throw new AssertionFailure("Unknown LockModeType: " + lockMode);
    }

    @Override
    public void adjustFlushMode() {
        Session session = this.getSession();
        boolean isTransactionActive = this.isTransactionInProgress();
        if (isTransactionActive && session.getFlushMode() == FlushMode.NEVER) {
            log.debug((Object)("Transaction activated, move to FlushMode " + this.flushMode));
            this.setFlushMode(this.flushMode);
        } else if (!isTransactionActive && session.getFlushMode() != FlushMode.NEVER) {
            log.debug((Object)"Transaction not active, move to FlushMode NEVER");
            session.setFlushMode(FlushMode.NEVER);
        }
    }

    @Override
    public boolean isTransactionInProgress() {
        return ((SessionImplementor)this.getSession()).isTransactionInProgress();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.tx = new TransactionImpl(this);
    }
}

