<?php
require_once 'Zend/Validate/Abstract.php';

class CustomZF_Validate_DoubleInputConfirmation extends Zend_Validate_Abstract {
    
    const NOT_MATCH = 'doubleIputNotMatch';
    
    protected $_messageTemplates = array(
        self::NOT_MATCH => ' not match the confirmation input ',
    );
    
    protected $_messageVariables = array(
        'confirm_field_name' => '_confirm_filed_mame',
    );
    
    protected $_confirm_filed_mame;

    public function __construct($confirm_field_name = "_confirm")
    {
        $this->setConfirmFieldName($confirm_field_name);
    }
    
    public function setConfirmFieldName($field_name) {
        $this->_confirm_filed_mame = $field_name;
    }
    
    public function isValid($value, $context = null) {
        
        $value = (string) $value;
        $this->_setValue($value);
        if (is_array($context)) {
            if (isset($context[$this->_confirm_filed_mame]) && ($value == $context[$this->_confirm_filed_mame])) {
                return true;
            }
        } else if (is_string($context) && ($value == $context)) {
            return true;
        }
        $this->_error(self::NOT_MATCH);
        return false;    
    }
}
?>