<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 問い合わせ承認のフォームクラス
 * 
 *
 */
class Inqman_ApproveForm extends Inqman_InquiryForm
{
    /**
     * @see AbstractForm::_prepareFilters()
     *
     */
    protected function _prepareFilters() {
    }
    
    /**
     * @see AbstractForm::_prepareValidators()
     *
     */
    protected function _prepareValidators() {
        $validators = array();
        $validate_config = $this->_config->validate->inquiry;
        
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_Int());
        $validators[self::ID] = $fieldValidator;
        
        $fieldValidator = new Zend_Validate();        
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_StringLength(0, $validate_config->subject->get('max_length', 200)));
        $validators[self::SUBJECT] = $fieldValidator;
        
        //FROMフィールドのバリデーション設定
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_StringLength(0, $validate_config->received_from->get('max_length', 200)))
        ;
        $validators[self::RECEIVED_FROM] = $fieldValidator;
        
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_StringLength(0, $validate_config->content->get('max_length', 2000)));
        $validators[self::CONTENT] = $fieldValidator;
        
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true);
        $validators[self::PRIORITY] = $fieldValidator;
        
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true);
        $validators[self::SERVICE_ID] = $fieldValidator;
        
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_StringLength(0, $validate_config->memo->get('max_length', 2000)));
        $validators[self::MEMO] = $fieldValidator;

        return $validators;
    }
    
}