/*
 * IIIMF-SKK, Japanese Language Engine for
 *                        IIIMF (Internet/Intranet Input Method Framework)
 *
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */
                                                                                                          
/* $Id: skktray.c,v 1.1.2.1 2003/01/22 15:24:32 famao Exp $ */
                                                                                                          
/* vi:set ts=4 sw=4: */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "menu.h"
#include "tray.h"
#include "wmutil.h"
#include "pixmaputil.h"
#include "pixmaps/tray.xpm"
#include "skk_xaux.h"
#include "support.h"

#ifndef SKK_AUX_SKK_TRAY_DEBUG
extern void skk_aux_palette_send_engine (gint count, gint *integers, 
		gint str_count, gchar **strings);
#endif

static void _tray_clicked (GtkWidget *widget, gpointer user_data);
static void _tray_activate (GtkMenuItem *item, gpointer user_data);
static gint _tray_enter (GtkWidget *widget, GdkEventAny *event, gpointer user_data);
static gint _tray_leave (GtkWidget *widget, GdkEventAny *event, gpointer user_data);


static guint message_id = 0;

static void
_tray_clicked (GtkWidget *widget, gpointer user_data)
{
	TrayWindow *tray = (TrayWindow *)user_data;
	GtkWidget *menu = (GtkWidget *)tray->data;
	gtk_menu_popup (GTK_MENU (menu), NULL, NULL,
			NULL, widget, 0, 0);
}

static void
_tray_activate (GtkMenuItem *item, gpointer user_data)
{
#ifndef SKK_AUX_SKK_TRAY_DEBUG
	gint send_status[1];
	send_status[0] = GPOINTER_TO_INT (menu_item_get_activate_data (GTK_WIDGET (item)));
	skk_aux_palette_send_engine (1, send_status, 0, NULL);
#endif
}

static gint
_tray_enter (GtkWidget *widget, GdkEventAny *event, gpointer user_data)
{
	g_message ("focus_in");
	wmutil_window_tray_baloon_start (widget->window, strlen ("iiimf-skk"), message_id);
	wmutil_window_tray_baloon (widget->window, "iiimf-skk", 9);
	message_id++;
	return FALSE;
}

static gint
_tray_leave (GtkWidget *widget, GdkEventAny *event, gpointer user_data)
{
	g_message ("focus_out");
	wmutil_window_tray_baloon_start (widget->window, 0, message_id);
	message_id++;
	return FALSE;
}

static void
_xembed_ended_handler (TrayWindow *tray)
{
	/*
	 * FIXME
	 */
	gtk_widget_hide (tray->window);
}

static GdkFilterReturn
_xembed_event_handler (TrayWindow *tray, XClientMessageEvent *e)
{
	switch (e->data.l[1]) {
		case XEMBED_EMBEDDED_NOTIFY:
			tray->flags |= TRAY_EMBEDDED;
			tray->embed_win = e->data.l[3];
			break;
	}
	g_message ("%lx %lx %lx %lx %lx", 
			e->data.l[0],
			e->data.l[1],
			e->data.l[2],
			e->data.l[3],
			e->data.l[4]
		  );
#if 1
	return GDK_FILTER_REMOVE;
#else
	return GDK_FILTER_CONTINUE;
#endif
}

static GtkWidget *
_create_window (TrayWindow *tray)
{
	GtkWidget *window;
	GtkWidget *button;
	GtkWidget *icon;

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	icon = pixmap_new_with_xpm (window, tray_xpm);
	button = pixmap_button_new (NULL, icon);
	gtk_container_add (GTK_CONTAINER (window), button);
	gtk_container_set_resize_mode (GTK_CONTAINER (button), GTK_RESIZE_PARENT);
	gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
	gtk_widget_show (button);
	gtk_signal_connect (GTK_OBJECT (window), "enter_notify_event",
			GTK_SIGNAL_FUNC (_tray_enter), NULL);
	gtk_signal_connect (GTK_OBJECT (window), "leave_notify_event",
			GTK_SIGNAL_FUNC (_tray_leave), NULL);
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC (_tray_clicked), tray);
	return window;
}

static MenuEntry _skk_tray_menu_entry[] = 
{
        { N_("hiragana"), SKK_MODE_JMODE_HIRA, _tray_activate },
        { N_("katakana"), SKK_MODE_JMODE_KATA, _tray_activate },
        { N_("jisx0201_kana"), SKK_MODE_JISX0201_KANA, _tray_activate },
        { N_("jisx0208_latin"), SKK_MODE_JISX0208_LATIN, _tray_activate },
        { N_("latin"), SKK_MODE_LATIN , _tray_activate },
        { N_("abbrev"), SKK_MODE_ABBREV , _tray_activate },
        { NULL, 0 , NULL }

};

TrayWindow *
skk_tray_window_new (void)
{
	TrayWindow *ret;
	GtkWidget *menu;
	ret = tray_window_new ();
	tray_window_set_create_window (ret, _create_window);
	tray_window_set_xembed_event_handler (ret, _xembed_event_handler);
	tray_window_set_xembed_ended_handler (ret, _xembed_ended_handler);
	menu = radio_menu_new (_skk_tray_menu_entry, ret);
	ret->data = (gpointer) menu;
	return ret;
}

GtkWidget *
skk_tray_window_get_menu (TrayWindow *tray)
{
	GtkWidget *menu;
	if (!tray)
		return NULL;
	menu = (GtkWidget *)tray->data;
	if (GTK_IS_MENU (menu))
		return menu;
	else
		return NULL;
}

#ifdef SKK_AUX_SKK_TRAY_DEBUG
int
main (int argc, char **argv)
{
	TrayWindow *tray;
	gtk_init (&argc, &argv);
	tray = skk_tray_window_new ();
	tray_window_show (tray);
	gtk_main ();
	return 0;
}

#endif
