/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 *
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkquery.h,v 1.1.1.1.2.9 2002/10/28 09:25:41 famao Exp $ */

/* vi:set ts=4 sw=4: */

#ifndef HAVE_SKKQUERY_H
#define HAVE_SKKQUERY_H

#include <glib.h>
#include <gmodule.h>
#include <skktypes.h>
#include <skkconf.h>

typedef struct _SkkQuery SkkQuery;
typedef struct _SkkQueryPlugin SkkQueryPlugin;
typedef struct _SkkQueryItem SkkQueryItem;
typedef struct _SkkQueryFunctionImpl SkkQueryFunctionImpl;

struct _SkkQueryPlugin
{
	SkkQueryType type;
	gchar *file;
	gchar *info;
	gint num_use;
	GModule *handle;
	SkkQueryFunctionImpl* (*impl_init) (SkkQuery *query);
};

struct _SkkQueryItem
{
	SkkQueryType type;
	SkkQueryFunctionImpl *impl;
};

struct _SkkQuery
{
	gint ref_count;
	gint cur_list_num;
	gboolean initialized;
	GList *query_list;
	GList *plugin_list;
	SkkQueryItem *cur_item;
	SkkConf *conf;
};

#define skk_query_set_first(x) skk_query_set_nth((x), 0)

SkkQuery* skk_query_new (void);
SkkQuery* skk_query_new_with_path (const gchar *path);
SkkQueryItem* skk_query_item_new (SkkQuery *query, SkkQueryType type);
void skk_query_destroy (SkkQuery *query);
void skk_query_add_item (SkkQuery *query, SkkQueryItem *item);
void skk_query_remove_item (SkkQuery *query, SkkQueryType type);

gboolean skk_query_set_with_type (SkkQuery *query, SkkQueryType type);
gboolean skk_query_set_next (SkkQuery *query);
gboolean skk_query_set_prev (SkkQuery *query);
gboolean skk_query_set_nth (SkkQuery *query, gint nth);

GList *skk_query_do_query (SkkQuery *query, const gchar *buf, const gchar *okuri, gint *found_num);
GList *skk_query_do_completion (SkkQuery *query, const gchar *buf);
void skk_query_add (SkkQuery *query, const gchar *key, const gchar *okuri, const gchar *value);

void skk_query_ref (SkkQuery *query);
void skk_query_unref (SkkQuery *query);

void skk_query_set_conf (SkkQuery *query, SkkConf *conf);
gchar *skk_query_get_conf_string_by_name (SkkQuery *query, const gchar *name);
gboolean skk_query_get_conf_bool_by_name (SkkQuery *query, const gchar *name);
gint skk_query_get_conf_num_by_name (SkkQuery *query, const gchar *name);

#endif
