/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 *
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */
                                                                                                                                       
/* $Id: skkdictutil.c,v 1.1.2.5 2003/02/15 05:47:42 famao Exp $ */
                                                                                                                                       
/* vi:set ts=4 sw=4: */

#include <string.h>
#include "skkdictutil.h"

gchar*
skk_dict_util_encode_string (const gchar *str)
{
	guint enc = 0;
	const gchar *p = str;
	gchar *ret;
	gchar *q;
	g_message ("dict_util_encode");
	if (!str)
		return NULL;
	g_message ("dict_util_encode %s", str);
	while (*p != '\0') {
		switch (*p) {
			case '\r':
				enc++;
				break;
			case '\n':
				enc++;
				break;
			case '/':
				enc+=3;
				break;
			case '"':
				enc+=2;
				break;
			case '\\':
				enc++;
				break;
			case '[':
				enc++;
				break;
			case ';':
				enc+=3;
				break;
			default:
				break;
		}
		p++;
	}
	if (!enc)
		return g_strdup (str);
	/* (concat "length") */
	ret = g_new0 (gchar, 9 + enc + strlen (str) + 2 + 1);
	memcpy (ret, "(concat \"", 9);
	p = str;
	q = ret + 9;
	while (*p != '\0') {
		switch (*p) {
			case '\r':
				memcpy (q, "\\r", 2);
				q += 2;
				break;
			case '\n':
				memcpy (q, "\\n", 2);
				q += 2;
				break;
			case '/':
				memcpy (q, "\\057", 4);
				q += 4;
				break;
			case '"':
				memcpy (q, "\\\"", 2);
				q += 2;
				break;
			case '\\':
				memcpy (q, "\\\\", 2);
				q += 2;
				break;
			case '[':
				memcpy (q, "\\[", 2);
				q += 2;
				break;
			case ';':
				memcpy (q, "\\073", 4);
				q += 4;
				break;
			default:
				*q = *p;
				q++;
				break;
		}
		p++;
	}
	memcpy (q, "\")", 2);
	q+=2;
	*q = '\0';
	g_message ("ret %s", ret);
	return ret;
}

gchar *
skk_dict_util_decode_string (const gchar *str)
{
	const gchar *p = str;
	gchar *q;
	gchar *ret;
	g_message ("dict_util_decode");
	if (!str)
		return NULL;
	g_message ("dict_util_decode %s", str);
	if (strncmp (str, "(concat \"", 9)) {
		return g_strdup (str);
	}
	ret = q = g_new0 (gchar, strlen (str) + 1);
	p += 9;
	while (*p != '\0') {
		if (*p == '\\') {
			p++;
			if (*p == '\\') {
				*q = *p;
				p++;
			} else if (*p == 'r') {
				*q = '\r';
				p++;
			} else if (*p == 'n') {
				*q = '\n';
				p++;
			} else if (*p == '\"') {
				*q = *p;
				p++;
			} else if (*p == '[') {
				*q = *p;
				p++;
			} else if (!strncmp (p, "057", 3)) {
				*q = '/';
				p += 3;
			} else if (!strncmp (p, "073", 3)) {
				*q = ';';
				p += 3;
			}
			q++;
		} else if (*p == '\"') {
			break;
		} else {
			*q = *p;
			q++;
			p++;
		}
	}
	*q++ = '\0';
	g_message ("ret %s", ret);
	return ret;
}

#ifdef SKKDICTUTIL_DEBUG
int
main (void)
{
	gchar *encode_str;
	gchar *decode_str;
	encode_str = skk_dict_util_encode_string ("http;//\\[\n;");
	g_message ("encode %s", encode_str);
	decode_str = skk_dict_util_decode_string (encode_str);
	g_message ("decode %s", decode_str);
	g_free (encode_str);
	g_free (decode_str);
	return 0;
}
#endif
