#ifndef HAVE_QUERY_IMPL_H
#define HAVE_QUERY_IMPL_H

#include <glib.h>

typedef struct _SkkQueryFunctionImpl SkkQueryFunctionImpl;

struct _SkkQueryFunctionImpl
{
	SkkQueryFunctionImpl * (*impl_new) (void);
	gboolean (*set_next) (SkkQueryFunctionImpl *impl);
	gboolean (*set_prev) (SkkQueryFunctionImpl *impl);
	gboolean (*set_nth) (SkkQueryFunctionImpl *impl, gint nth);
	GList *  (*do_query) (SkkQueryFunctionImpl *impl, const gchar *buf, const gchar *okuri, gint *found_num);
	GList *  (*completion) (SkkQueryFunctionImpl *impl, const gchar *buf);
	void     (*add) (SkkQueryFunctionImpl *impl, const gchar *key, const gchar *okuri, const gchar *value);
	void     (*destroy) (SkkQueryFunctionImpl *impl);
	const gchar *  (*get_info) (void);
	gint	 (*get_type) (void);
	GList *  (*get_arg) (void);
	void     (*set_arg) (GList *arg);
};

SkkQueryFunctionImpl *impl_init (void);

#endif
