/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkqueryimpl.c,v 1.1.1.1.2.1 2002/04/15 09:31:53 famao Exp $ */

/* vi:set ts=4 sw=4: */


#include <string.h>
#include <glib.h>
#include "skkldict2.h"
#include "skkutils.h"
#include "skkdebug.h"
#include "skkqueryimpl.h"

static SkkQueryFunctionImpl* get_new (void);
static gboolean set_next (SkkQueryFunctionImpl *impl);
static gboolean set_prev (SkkQueryFunctionImpl *impl);
static gboolean set_nth (SkkQueryFunctionImpl *impl, gint nth);
static GList *  do_query (SkkQueryFunctionImpl *impl, gchar *buf, gchar *okuri, gint *found_num);
static GList *  completion (SkkQueryFunctionImpl *impl, gchar *buf);
static void     add (SkkQueryFunctionImpl *impl, const gchar *key, const gchar *okuri, const gchar *value);
static void     destroy (SkkQueryFunctionImpl *impl);
static gchar *	get_info (void);
static gint		get_type (void);

static SkkQueryFunctionImpl localdictimpl = 
{
	get_new,
	set_next,
	set_prev,
	set_nth,
	do_query,
	completion,
	add,
	destroy,
	get_info,
	get_type,
	NULL,
	NULL,
};

static gchar *
get_info (void)
{
	return "SkkQueryFunctionImpl template";
}

static gint
get_type (void)
{
	return 0;
}

static SkkQueryFunctionImpl *
get_new (void)
{
	SkkLocalDict *ldict;
	ldict = g_new (SkkLocalDict, 1);
	memset (ldict, 0, sizeof (SkkLocalDict));
	ldict->impl = localdictimpl;
	ldict->fuga = "fuga";
	return (SkkQueryFunctionImpl*)ldict;
}

static void
destroy (SkkQueryFunctionImpl *impl)
{
	SkkLocalDict *dict = (SkkLocalDict *)impl;
	g_free (dict);
	return;
}

static GList *
do_query (SkkQueryFunctionImpl *impl, gchar *buf, gchar *okuri, gint *fount_num)
{
	g_message ("do_query %s %s", buf, okuri);
	return NULL;
}

static GList *
completion (SkkQueryFunctionImpl *impl, gchar *buf)
{
	g_message ("completion %s",buf);
	return NULL;
}

static void
add (SkkQueryFunctionImpl *impl, const gchar *key, const gchar *okuri, const gchar *value)
{
	g_message ("add");
}

static gboolean
set_next (SkkQueryFunctionImpl *impl)
{
	g_message ("set_next");
	return TRUE;
}

static gboolean
set_nth (SkkQueryFunctionImpl *impl, gint nth)
{
	g_message ("set_nth");
	return TRUE;
}

static gboolean
set_prev (SkkQueryFunctionImpl *impl)
{
	g_message ("set_prev");
	return TRUE;
}

SkkQueryFunctionImpl *
skk_ldict_new (void)
{
	SkkQueryFunctionImpl *impl;
	impl = localdictimpl.impl_new ();
	return impl;
}

SkkQueryFunctionImpl *
impl_init (void)
{
	return skk_ldict_new ();
}

#ifdef SKKIMPL_DEBUG
int
main (void)
{
	SkkQueryFunctionImpl *impl;
	SkkLocalDict *localdict;
	impl = skk_ldict_new ();
	impl->set_prev (impl);
	impl->set_nth (impl, 1);
	localdict = (SkkLocalDict*)impl;
	g_message ("localdict fuga %s", localdict->fuga);
	g_message ("info %s", impl->get_info ());
	return 0;
}
#endif
