/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skktypes.h,v 1.4.2.3 2002/04/12 21:54:11 famao Exp $ */

/* vi:set ts=4 sw=4: */


#ifndef HAVE_SKKTYPES_H
#define HAVE_SKKTYPES_H

/* skkmode */
typedef enum {
	SKK_NONE   = 1 << 0,
	SKK_HENKAN = 1 << 1,
	SKK_OKURI  = 1 << 2,
	SKK_CHOICE = 1 << 3
}SkkJStatus;

typedef enum {
	SKK_J_MODE              = 1 << 0,
	SKK_LATIN_MODE          = 1 << 1,
	SKK_JISX0208_LATIN_MODE = 1 << 2,
	SKK_ABBREV_MODE         = 1 << 3
}SkkStatus;

/* must sync with SkkStatus */
typedef enum {
	SKK_FUNC_JMODE          = 1 << 0,
	SKK_FUNC_LATIN          = 1 << 1,
	SKK_FUNC_JISX0208_LATIN = 1 << 2,
	SKK_FUNC_ABBREV         = 1 << 3,
	SKK_FUNC_ALL            = 0xffff
}SkkFunctionType;

typedef enum {
	QUERY_NONE   = 1 << 0,
	QUERY_NORMAL = 1 << 1,
	QUERY_OKURI  = 1 << 2,
	QUERY_DONE   = 1 << 3,
	QUERY_ALL    = 0xffff
}SkkQueryStatus;

/* skkcomm */
typedef enum {
	SKKSERV_BYE = 0,
	SKKSERV_SEARCH,
	SKKSERV_VERSION,
	SKKSERV_HOSTNAME
}SkkServInfo;

/* skkldict */
typedef enum {
	SKKDICT_OKURIARI = 0,
	SKKDICT_OKURINASI
}SkkAddDictInfo;	

/* skkquery */
typedef enum {
	SKKQUERY_FILE = 0,
	SKKQUERY_LOCAL,
	SKKQUERY_LOOK,
	SKKQUERY_SERVER
}SkkQueryType;

typedef enum {
	SKK_SHIFT_MASK    = 1 << 0,
	SKK_LOCK_MASK     = 1 << 1,
	SKK_CONTROL_MASK  = 1 << 2,
	SKK_MOD1_MASK     = 1 << 3,
	SKK_ALT_MASK      = SKK_MOD1_MASK,
	SKK_MOD2_MASK     = 1 << 4,
	SKK_MOD3_MASK     = 1 << 5,
	SKK_MOD4_MASK     = 1 << 6,
	SKK_MOD5_MASK     = 1 << 7,
	SKK_BUTTON1_MASK  = 1 << 8,
	SKK_BUTTON2_MASK  = 1 << 9,
	SKK_BUTTON3_MASK  = 1 << 10,
	SKK_BUTTON4_MASK  = 1 << 11,
	SKK_BUTTON5_MASK  = 1 << 12,
	SKK_RELEASE_MASK  = 1 << 13,
	SKK_NONE_MASK     = 1 << 14,
	SKK_MODIFIER_MASK = 0x3fff,
	SKK_ALL_MASK      = 0xffff
} SkkModifierType;

typedef enum {
	SKK_NOTHING     = -1,
	SKK_NOTRANS     = -2,
	SKK_TRANS       = -3,
	SKK_INSERT_CHAR = -4
} SkkKeyResult;

typedef enum {
	SKKCONF_FUGA
}SkkConfBool;

typedef enum {
	SKKCONF_HOGE
}SkkConfString;

typedef enum {
	SKKFUNC_TRANSLATE_BEGIN = 1,
	SKKFUNC_BACKWARD_DELETE,
	SKKFUNC_CANCEL,
	SKKFUNC_CATEGORY_CHANGE,
	SKKFUNC_CODETABLE,
	SKKFUNC_COMPLETE_BEGIN,
	SKKFUNC_COMPLETE_NEXT,
	SKKFUNC_COMPLETE_PREV,
	SKKFUNC_COMPLETE_TRANSLATE,
	SKKFUNC_HALFWIDTH_KANA_SWITCH,
	SKKFUNC_KAKUTEI,
	SKKFUNC_KANA_SWITCH,
	SKKFUNC_MODE_CHANGE,
	SKKFUNC_POSTFIX,
	SKKFUNC_PREFIX,
	SKKFUNC_TODAY,
	SKKFUNC_UNDO
}SkkFunction;
#endif /* HAVE_SKKTYPES_H */
