#include "skkdictimpl.h"
#include "skkdictitem.h"
#include "skkcomm.h"
#include "skktypes.h"

static SkkQueryFunctionImpl *get_new (void);
static GList *do_query (SkkQueryFunctionImpl *impl, const gchar *buf, const gchar *okuri, gint *found_num);
static void destroy (SkkQueryFunctionImpl *impl);
static const gchar *get_info (void);
static gint get_type (void);

static SkkQueryFunctionImpl dictimpl = {
	get_new,
	NULL,
	NULL,
	NULL,
	do_query,
	NULL,
	NULL,
	destroy,
	get_info,
	get_type,
	NULL,
	NULL,
};

static SkkQueryFunctionImpl *get_new (void)
{
	SkkDictImpl *impl;
	impl = g_new0 (SkkDictImpl, 1);
	impl->impl = dictimpl;
	impl->sock = -1;
	return (SkkQueryFunctionImpl*) impl;
}

static GList *
do_query (SkkQueryFunctionImpl *impl, const gchar *buf, const gchar *okuri, gint *found_num)
{
	GList *ret = NULL;
	gchar *query_result;
	gchar *query_str;
	gchar **list;
	gchar *list_count;
	gint query_status;
	gint found;
	gint i;
	SkkDictImpl *d = (SkkDictImpl *)impl;
	if (!buf)
		return NULL;
	if (d->sock < 0) {
		d->sock = skk_comm_makesock ("localhost", "skkserv");
	}
	if (okuri) {
		query_str = g_strdup_printf ("%s%c", buf, okuri[0]);
	} else {
		query_str = g_strdup (buf);
	}
	skk_comm_send (d->sock, SKKSERV_SEARCH, query_str);
	skk_comm_recv (d->sock, &query_result, &query_status);
	if (query_status == 4 || !query_result) {
		if (query_result) {
			g_free (query_result);
		}
		if (found_num) {
			*found_num = 0;
		}
		g_free (query_str);
		return NULL;
	}
	list = g_strsplit (query_result, "/", strlen (query_result));
	for (i = 0, list_count = list[0], found = 0;
			list_count;
			i++, list_count = list[i]) {
		if (list_count && *list_count == '\0') {
			continue;
		}
		ret = g_list_append (ret, (gpointer) skk_dict_item_new_with_string (list_count, ";"));
		found++;
	}
	if (found_num)
		*found_num = found;
	g_free (query_result);
	g_free (query_str);
	g_strfreev (list);
	return ret;
}

static void
destroy (SkkQueryFunctionImpl *impl)
{
	SkkDictImpl *d = (SkkDictImpl *)impl;
	if (!(d->sock < 0)) {
		skk_comm_bye (d->sock);
		shutdown (d->sock, 2);
	}
	g_free (d);
	return;
}

static gint
get_type (void)
{
	return SKKQUERY_SERVER;
}

static const gchar *
get_info (void)
{
	return NULL;
}

SkkQueryFunctionImpl *skk_dict_new (void)
{
	return get_new ();
}

SkkQueryFunctionImpl *impl_init (void)
{
	return get_new ();
}

#ifdef SKKDICTIMPL_DEBUG
int
main (void)
{
	SkkQueryFunctionImpl *dict;
	GList *result;
	dict = skk_dict_new ();
	result = dict->do_query (dict, "礦", NULL, NULL);
	g_message ("do_query %s", skk_dict_item_to_string_all (result, "/", ";"));
	return 0;
}
#endif
