/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkconv_jisx0208_latin.c,v 1.3 2002/03/15 21:32:40 famao Exp $ */

/* vi:set ts=4 sw=4: */


#include <stdio.h>
#include <glib.h>
#include "skkconv_jisx0208_latin_private.h"
#include "skkconv_jisx0208_latin.h"

const gchar *
skkconv_get_jisx0208_latin (gint ch)
{
	if (ch < 0 || ch > 128) return NULL;
	return skk_jisx0208_latin_vector[ch];
}

gchar *
skkconv_get_jisx0208_latin_from_str (const gchar *str, gboolean store)
{
	gchar *ret = NULL;
	gchar *tmp_result;
	const gchar *tmp_buf;
	const guchar *p;
	for (p = str; p && *p; p++) {
		tmp_buf = skkconv_get_jisx0208_latin (*p);
		if (!tmp_buf) {
			if (store) {
				if (!ret) {
					ret = g_strdup_printf ("%c",*p);
				} else {
					tmp_result = ret;
					ret = g_strdup_printf ("%s%c", ret, *p);
					g_free (tmp_result);
				}
			}
			continue;
		}
		if (!ret) {
			ret = g_strdup (tmp_buf);
		} else {
			tmp_result = ret;
			ret = g_strconcat (ret, tmp_buf, NULL);
			g_free (tmp_result);
		}
	}
	return ret;
}

#ifdef SKKCONV_JISX0208_LATIN_DEBUG
int
main(void)
{
	int ch;
	const gchar *str;
	for (ch = 0; ch < 128; ch++) {
		str = skkconv_get_jisx0208_latin (ch);
		if (str)
			printf ("%d (%c:%s)\t",ch,ch,str);
		if (ch > 31 && !(ch % 8))
			printf ("\n");
	}
	printf ("\n");
	printf ("%s\n", skkconv_get_jisx0208_latin_from_str ("ʿ14ǯ", TRUE));
	return 0;
}
#endif
