/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkcomm.c,v 1.4 2002/03/15 23:00:49 famao Exp $ */

/* vi:set ts=4 sw=4: */


#include <glib.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <netdb.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "skkcomm.h"
#include "skkdebug.h"

/* FIXME */
static int recent_cmd = SKKSERV_BYE;

gint
skk_comm_makesock (gchar * host, gchar * service)
{
  struct addrinfo hints, *res, *res0;
  int sock = -1;
  memset (&hints, 0, sizeof (hints));
  hints.ai_socktype = SOCK_STREAM;
  if (getaddrinfo (host, service, &hints, &res0)) {
	  return -1;
  }

  for (res = res0; res; res = res->ai_next) {
      sock = socket (res->ai_family, res->ai_socktype, 0);
      if (sock < 0)
		  continue;
      if (connect (sock, (struct sockaddr *) res->ai_addr, res->ai_addrlen) < 0) {
		  close (sock);
		  continue;
	  }
      break;
  }
  freeaddrinfo (res0);
  return sock;
}

gboolean
skk_comm_send (gint sock, SkkServInfo info, gchar * string)
{
	/* store recent status */
	recent_cmd = info;
  switch (info)
    {
    case SKKSERV_BYE:
    case SKKSERV_VERSION:
    case SKKSERV_HOSTNAME:
      {
	gchar *push = g_strdup_printf ("%d\n", info);
	send (sock, (void *) push, strlen (push), 0);
	g_free (push);
      }
      break;
    case SKKSERV_SEARCH:
	  {
		  gchar *push = g_strdup_printf ("1%s \n",string);
	      send (sock, (void *) push, strlen (push), 0);
		  g_free (push);
	  }
      break;
    default:
      return FALSE;
      break;
    }
  return TRUE;
}

gboolean
skk_comm_recv (gint sock, gchar ** answer,gint *recv_status)
{
  gint len = BUFSIZ;
  gint retlen;
  guchar status;
  gchar *val;

  /* first, get status */
  if (recent_cmd == SKKSERV_SEARCH )
	  retlen = recv (sock, (void *) &status, 1, 0);
  val = g_malloc (len);

  while (TRUE) {
	  if ((retlen = recv (sock, (void *) val, len, MSG_PEEK)) < len)
	  {
		  gchar *tmp;
		  tmp = strchr (val, '\n');
		  if (tmp) {
			  retlen = tmp - val + 1;
		  }
		  g_realloc (val, retlen);
		  break;
	  }
      len = len * 2;
      val = g_realloc (val, len);
  }
  recv (sock, (void *) val, retlen, 0);
  val[retlen - 1] = '\0';
#ifdef SKKCOMM_DEBUG
  g_message ("skk_comm_recv \tval %s#", val);
#endif
  if (answer)
    *answer = val;
  else {
    g_free (val);
  }
  if (recv_status) {
	  *recv_status = atoi (&status);
	  DEBUG_DO (printf ("skkcomm.c : skk_comm_recv status (%d)\n", *recv_status));
  }
  return TRUE;
}

#ifdef SKKCOMM_DEBUG
int
main (gint argc, gchar ** argv)
{

  gint sock;
  gint status;
  gchar *mes;
  gchar **split;
  gchar *sp;
  int c;
  sock = skk_comm_makesock ("localhost", "skkserv");
  skk_comm_send (sock, SKKSERV_SEARCH, "j");
  skk_comm_recv (sock, &mes, &status);
  if (mes)
	  printf ("result :%s\n", mes);
  skk_comm_send (sock, SKKSERV_SEARCH, "");
  skk_comm_recv (sock, &mes, &status);
  if (mes)
	  printf ("result :%s\n", mes);

  split = g_strsplit (mes, "/", strlen (mes));
  for (c = 0, sp = split[c] ; sp ; c++,sp = split[c])
  {
	  if (!*sp) continue;
	  printf ("%s\n", sp);
  }
  skk_comm_send (sock, SKKSERV_SEARCH, "k");
  skk_comm_recv (sock, &mes, &status);
  if (mes)
	  printf ("result :%s\n", mes);
  skk_comm_send (sock, SKKSERV_SEARCH, "#m");
  skk_comm_recv (sock, &mes ,&status);
  if (mes)
	  printf ("result :%s\n", mes);
  skk_comm_hostname (sock);
  skk_comm_recv (sock, NULL,NULL);
  skk_comm_version (sock);
  skk_comm_recv (sock, NULL,NULL);
  shutdown (sock, 2);
  close (sock);
  return 0;
}
#endif
