/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkmode.h,v 1.3 2002/11/09 16:56:49 famao Exp $ */

/* vi:set ts=4 sw=4: */


#ifndef HAVE_SKKMODE_H
#define HAVE_SKKMODE_H
#include <glib.h>
#include <skktypes.h>

typedef struct _SkkMode SkkMode;

typedef void (*SkkModeListener)(SkkMode *mode, gint status, gpointer user_data);

struct _SkkMode
{
	gchar *query_prefix;
	gchar *query_suffix;
	gchar *status_buf;
	gchar *latin_str;
	gchar *hirakana_str;
	gchar *katakana_str;
	gchar *jisx0208_latin_str;
	gchar *jisx0201_kana_str;
	gchar *abbrev_str;
	gboolean katakana;
	gboolean jisx0201_kana;
	SkkStatus status;
	SkkJStatus jstatus;
	SkkQueryStatus query_status;

	GList *status_listener;
	GList *j_status_listener;
	GList *query_status_listener;

	/* Function */
	void (*clear)(SkkMode *mode);
	void (*set_status)(SkkMode *mode,SkkStatus status);
	void (*set_j_status) (SkkMode *mode, SkkJStatus jstatus);
	void (*set_query_status) (SkkMode *mode, SkkQueryStatus status);
	void (*prepare_mark) (SkkMode *mode);
	gchar* (*get_status_string) (SkkMode *mode);
	SkkStatus (*get_status) (SkkMode *mode);
	SkkJStatus (*get_j_status) (SkkMode *mode);
	SkkQueryStatus (*get_query_status) (SkkMode *mode);
};


SkkMode * skk_mode_new (void);
void skk_mode_destroy (SkkMode *mode);
void skk_mode_clear (SkkMode *mode);

void skk_mode_set_status (SkkMode *mode, SkkStatus status);
gchar * skk_mode_get_status_string (SkkMode *mode);
SkkStatus skk_mode_get_status (SkkMode *mode);

void skk_mode_set_katakana (SkkMode *mode,gboolean val);
gboolean skk_mode_get_katakana (SkkMode *mode);

void skk_mode_set_jisx0201_katakana (SkkMode *mode, gboolean val);
gboolean skk_mode_get_jisx0201_katakana (SkkMode *mode);

void skk_mode_prepare_mark (SkkMode *mode);

void skk_mode_set_query_status (SkkMode *mode, SkkQueryStatus status);
void skk_mode_get_query_status_strings (SkkMode *mode, const gchar **prefix, const gchar** append);
const gchar* skk_mode_get_query_status_prefix (SkkMode *mode);
const gchar* skk_mode_get_query_status_append (SkkMode *mode);
SkkQueryStatus skk_mode_get_query_status (SkkMode *mode);

void skk_mode_set_j_status (SkkMode *mode,SkkJStatus jstatus);
SkkJStatus skk_mode_get_j_status (SkkMode *mode);

void skk_mode_add_status_listener (SkkMode *mode, SkkModeListener listener, gpointer user_data);
void skk_mode_add_j_status_listener (SkkMode *mode, SkkModeListener listener, gpointer user_data);
void skk_mode_add_query_status_listener (SkkMode *mode, SkkModeListener listener, gpointer user_data);

gboolean skk_mode_remove_status_listener (SkkMode *mode, SkkModeListener listener);
gboolean skk_mode_remove_j_status_listener (SkkMode *mode, SkkModeListener listener);
gboolean skk_mode_remove_query_status_listener (SkkMode *mode, SkkModeListener listener);

void skk_mode_set_latin_str (SkkMode *mode, const gchar *str);
void skk_mode_set_hirakana_str (SkkMode *mode, const gchar *str);
void skk_mode_set_katakana_str (SkkMode *mode, const gchar *str);
void skk_mode_set_jisx0208_latin_str (SkkMode *mode, const gchar *str);
void skk_mode_set_jisx0201_kana_str (SkkMode *mode, const gchar *str);
void skk_mode_set_abbrev_str (SkkMode *mode, const gchar *str);
#endif /* HAVE_SKKCONV_MODE_H */
