/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkfunc.h,v 1.6 2002/11/09 16:56:49 famao Exp $ */

/* vi:set ts=4 sw=4: */


#ifndef HAVE_SKKFUNC_H
#define HAVE_SKKFUNC_H

#include <glib.h>
#include <skktypes.h>

typedef struct _SkkFunc SkkFunc;
typedef struct _SkkFuncItem SkkFuncItem;
typedef struct _SkkFuncResult SkkFuncResult;

struct _SkkFuncResult {
	gint actual_key;
	gint  result;
};

struct _SkkFuncItem {
	guint mode;
	guint submode;
	guint key ;
	guint mask;
	guint result;
	guint actual_key;
	gboolean user_defined;
};

struct _SkkFunc {
	gint  ref_count;
	GList *jmode_func_list;
	GList *abbrev_func_list;
	GList *latin_func_list;
	GList *jisx0208_latin_func_list;
};

/* SkkFunc */
SkkFunc* skk_func_new (void);
void skk_func_destroy (SkkFunc *func);
void skk_func_ref (SkkFunc *func);
void skk_func_unref (SkkFunc *func);
void skk_func_add_item (SkkFunc *func, SkkFuncItem *item);
SkkFuncResult* skk_func_do_query (SkkFunc *func, guint mode, guint submode, guint key, guint mask);

/* SkkFuncItem */
void skk_func_add_item (SkkFunc *func, SkkFuncItem *item);
void skk_func_item_destroy (SkkFuncItem *item);
SkkFuncItem *skk_func_item_new (guint mode, guint submode, guint key, guint mask, guint actual_key, guint result);


#endif /* HAVE_SKKFUNC_H */
