/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkconv_kana.h,v 1.4 2002/11/09 16:56:49 famao Exp $ */

/* vi:set ts=4 sw=4: */


#ifndef SKKCONV_KANA_H
#define SKKCONV_KANA_H
#include <glib.h>
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef HAVE_DB4_DB_H
#include <db4/db.h>
#elif HAVE_DB3_DB_H
#include <db3/db.h>
#else
#include <db.h>
#endif
#include <skktypes.h>

/* This file is generated from skk.el (skk-rom-kana-base-rule-list) */

#define SKKCONV_BASE_RULE_ENCODING	"EUC-JP"

typedef struct _SkkConvRuleItem SkkConvRuleItem;
typedef struct _SkkConvRule SkkConvRule;

struct _SkkConvRuleItem
{
	gchar *key;
	gchar *append;
	gchar *kata;
	gchar *hira;
	SkkConvRuleType type;
};

struct _SkkConvRule {
	gint ref_count;
	DB*  rule_db;
	gboolean initialized;
};

#define SKKCONV_BASE_RULE_SIZE ((sizeof (baselist))/(sizeof (baselist[0])))

extern SkkConvRuleItem baselist[];

SkkConvRule *skk_conv_rule_new (void);
void skk_conv_rule_destroy (SkkConvRule *rule);
void skk_conv_rule_unref (SkkConvRule *rule);
void skk_conv_rule_ref (SkkConvRule *rule);
gboolean skk_conv_add_rule(SkkConvRule *rule, SkkConvRuleItem *item);
gboolean skk_conv_delete_rule (SkkConvRule *rule, const gchar *key);
gchar   *skk_conv_get_hiragana (SkkConvRule *rule, const gchar *key, gchar **append);
gchar   *skk_conv_get_katakana (SkkConvRule *rule, const gchar *key,gchar **append);
gchar	*skk_conv_get_func (SkkConvRule *rule, const gchar *key);
gint     skk_conv_is_exist (SkkConvRule *rule, const gchar *key);
SkkConvRuleType skk_conv_get_type (SkkConvRule *rule, const gchar *key);

/* Utility */
gchar   *skk_conv_hiragana_to_katakana (const gchar *hiragana);
gchar   *skk_conv_katakana_to_hiragana (const gchar *katakana);

/* Item */
SkkConvRuleItem *skk_conv_rule_item_new (void);
SkkConvRuleItem *skk_conv_rule_item_new_with_value (const gchar *key, const gchar *hira, const gchar *kata, const gchar *append);
void skk_conv_rule_item_destroy (SkkConvRuleItem *item);


#endif /* SKKCONV_KANA_H */
