/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo.dictionary;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.reduls.igo.trie.Searcher;
import net.reduls.igo.util.FileMappedInputStream;
import net.reduls.igo.util.FileMappedOutputStream;
import net.reduls.igo.util.ReadLine;

public final class CharCategory {
    public static final String KEY_PREFIX = "\u0002";
    private final Category[] categorys;
    private final int[] char2id;
    private final int[] eqlMasks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharCategory(String string) throws IOException {
        this.categorys = this.readCategorys(string);
        FileMappedInputStream fileMappedInputStream = new FileMappedInputStream(string + "/code2category");
        try {
            this.char2id = fileMappedInputStream.getIntArray(fileMappedInputStream.size() / 4 / 2);
            this.eqlMasks = fileMappedInputStream.getIntArray(fileMappedInputStream.size() / 4 / 2);
        }
        finally {
            fileMappedInputStream.close();
        }
    }

    public Category category(char c) {
        return this.categorys[this.char2id[c]];
    }

    public boolean isCompatible(char c, char c2) {
        return (this.eqlMasks[c] & this.eqlMasks[c2]) != 0;
    }

    public static void build(String string, String string2, String string3) throws IOException {
        Map<String, Category> map = CharCategory.parseCharCategoryDef(string, string2, string3);
        ArrayList<Category> arrayList = new ArrayList<Category>();
        for (Category category : map.values()) {
            arrayList.add(category);
        }
        CharCategory.genCharCategoryMap(arrayList, string2);
        CharCategory.genCodeCategoryMap(map, string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void genCharCategoryMap(List<Category> list, String string) throws IOException {
        FileMappedOutputStream fileMappedOutputStream = new FileMappedOutputStream(string + "/char.category", list.size() * 4 * 4);
        try {
            Collections.sort(list);
            for (Category category : list) {
                fileMappedOutputStream.putInt(category.id);
                fileMappedOutputStream.putInt(category.length);
                fileMappedOutputStream.putInt(category.invoke ? 1 : 0);
                fileMappedOutputStream.putInt(category.group ? 1 : 0);
            }
        }
        finally {
            fileMappedOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Category> parseCharCategoryDef(String string, String string2, String string3) throws IOException {
        ReadLine readLine = new ReadLine(string + "/char.def", string3);
        Searcher searcher = new Searcher(string2 + "/word2id");
        HashMap<String, Category> hashMap = new HashMap<String, Category>();
        try {
            String string4;
            while ((string4 = readLine.read()) != null) {
                if (string4.isEmpty() || string4.startsWith("#") || string4.startsWith("0")) continue;
                String[] stringArray = string4.split("\\s+");
                String string5 = stringArray[0];
                boolean bl = stringArray[1].equals("1");
                boolean bl2 = stringArray[2].equals("1");
                short s = Short.valueOf(stringArray[3]);
                int n = searcher.search(KEY_PREFIX + string5);
                if (n < 0) {
                    throw new IOException("Category '" + string5 + "' is unregistered in trie");
                }
                hashMap.put(string5, new Category(n, s, bl, bl2));
            }
        }
        finally {
            readLine.close();
        }
        return hashMap;
    }

    private Category[] readCategorys(String string) throws IOException {
        int[] nArray = FileMappedInputStream.getIntArray(string + "/char.category");
        int n = nArray.length / 4;
        Category[] categoryArray = new Category[n];
        for (int i = 0; i < n; ++i) {
            categoryArray[i] = new Category(nArray[i * 4], nArray[i * 4 + 1], nArray[i * 4 + 2] == 1, nArray[i * 4 + 3] == 1);
        }
        return categoryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void genCodeCategoryMap(Map<String, Category> map, String string, String string2, String string3) throws IOException {
        Object object;
        CharId[] charIdArray = new CharId[65536];
        Object object2 = new CharId(map.get((Object)"DEFAULT").id);
        for (int i = 0; i < 65536; ++i) {
            charIdArray[i] = object2;
        }
        object2 = new ReadLine(string + "/char.def", string3);
        try {
            while ((object = ((ReadLine)object2).read()) != null) {
                int n;
                int n2;
                int n3;
                if (!((String)object).startsWith("0")) continue;
                Object[] objectArray = ((String)object).split("\\s+");
                if (objectArray[0].indexOf("..") != -1) {
                    String[] stringArray = objectArray[0].split("\\.\\.");
                    n3 = Integer.parseInt(stringArray[0].substring(2), 16);
                    n2 = Integer.parseInt(stringArray[1].substring(2), 16);
                } else {
                    n3 = n2 = Integer.parseInt(objectArray[0].substring(2), 16);
                }
                CharId object3 = new CharId(map.get((Object)objectArray[1]).id);
                for (n = 2; n < objectArray.length && !((String)objectArray[n]).startsWith("#"); ++n) {
                    object3.add(map.get((Object)objectArray[n]).id);
                }
                for (n = n3; n <= n2; ++n) {
                    charIdArray[n] = object3;
                }
            }
        }
        finally {
            ((ReadLine)object2).close();
        }
        object = new FileMappedOutputStream(string2 + "/code2category", charIdArray.length * 4 * 2);
        try {
            for (CharId charId : charIdArray) {
                ((FileMappedOutputStream)object).putInt(charId.id);
            }
            for (CharId charId : charIdArray) {
                ((FileMappedOutputStream)object).putInt(charId.mask);
            }
        }
        finally {
            ((FileMappedOutputStream)object).close();
        }
    }

    private static class CharId {
        public final int id;
        public int mask;

        public CharId(int n) {
            this.id = n;
            this.add(this.id);
        }

        public CharId(int n, int n2) {
            this.id = n;
            this.mask = n2;
        }

        public void add(int n) {
            this.mask |= 1 << n;
        }
    }

    public static class Category
    implements Comparable<Category> {
        public final int id;
        public final int length;
        public final boolean invoke;
        public final boolean group;

        public Category(int n, int n2, boolean bl, boolean bl2) {
            this.id = n;
            this.length = n2;
            this.invoke = bl;
            this.group = bl2;
        }

        @Override
        public int compareTo(Category category) {
            return this.id - category.id;
        }
    }
}

