/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.reduls.igo.Morpheme;
import net.reduls.igo.dictionary.Matrix;
import net.reduls.igo.dictionary.Unknown;
import net.reduls.igo.dictionary.ViterbiNode;
import net.reduls.igo.dictionary.WordDic;

public final class Tagger {
    private static final ArrayList<ViterbiNode> BOS_NODES = new ArrayList(1);
    private final WordDic wdc;
    private final Unknown unk;
    private final Matrix mtx;

    public Tagger(String string) throws IOException {
        this.wdc = new WordDic(string);
        this.unk = new Unknown(string);
        this.mtx = new Matrix(string);
    }

    public List<Morpheme> parse(String string) {
        ArrayList<Morpheme> arrayList = new ArrayList<Morpheme>();
        this.parse(string, arrayList);
        return arrayList;
    }

    public void parse(String string, List<Morpheme> list) {
        ArrayList<ViterbiNode> arrayList = this.parseImpl(string);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ViterbiNode viterbiNode = arrayList.get(i);
            String string2 = string.substring(viterbiNode.start, viterbiNode.start + viterbiNode.length);
            String string3 = this.wdc.wordData(viterbiNode.wordId);
            list.add(new Morpheme(string2, string3));
        }
    }

    public List<String> wakati(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.wakati(string, arrayList);
        return arrayList;
    }

    public void wakati(String string, List<String> list) {
        ArrayList<ViterbiNode> arrayList = this.parseImpl(string);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ViterbiNode viterbiNode = arrayList.get(i);
            list.add(string.substring(viterbiNode.start, viterbiNode.start + viterbiNode.length));
        }
    }

    private ArrayList<ViterbiNode> parseImpl(String string) {
        ArrayList arrayList;
        int n;
        int n2 = string.length();
        ArrayList arrayList2 = new ArrayList(n2 + 1);
        ArrayList<ViterbiNode> arrayList3 = new ArrayList<ViterbiNode>();
        arrayList2.add(BOS_NODES);
        for (n = 1; n <= n2; ++n) {
            arrayList2.add(new ArrayList());
        }
        for (n = 0; n < n2; ++n) {
            if (!((ArrayList)arrayList2.get(n)).isEmpty()) {
                this.wdc.search(string, n, arrayList3);
                this.unk.search(string, n, this.wdc, arrayList3);
                arrayList = (ArrayList)arrayList2.get(n);
                for (int i = 0; i < arrayList3.size(); ++i) {
                    ViterbiNode viterbiNode = arrayList3.get(i);
                    if (viterbiNode.isSpace) {
                        ((ArrayList)arrayList2.get(n + viterbiNode.length)).addAll(arrayList);
                        continue;
                    }
                    ((ArrayList)arrayList2.get(n + viterbiNode.length)).add(this.setMincostNode(viterbiNode, arrayList));
                }
            }
            arrayList3.clear();
        }
        ViterbiNode viterbiNode = this.setMincostNode((ViterbiNode)ViterbiNode.makeBOSEOS(), (ArrayList<ViterbiNode>)((ArrayList)arrayList2.get((int)n2))).prev;
        arrayList = new ArrayList(n2 / 2);
        while (viterbiNode.prev != null) {
            arrayList.add((ViterbiNode)viterbiNode);
            viterbiNode = viterbiNode.prev;
        }
        return arrayList;
    }

    private ViterbiNode setMincostNode(ViterbiNode viterbiNode, ArrayList<ViterbiNode> arrayList) {
        ViterbiNode viterbiNode2 = viterbiNode.prev = arrayList.get(0);
        viterbiNode.cost = viterbiNode2.cost + this.mtx.linkCost(viterbiNode2.rightId, viterbiNode.leftId);
        for (int i = 1; i < arrayList.size(); ++i) {
            ViterbiNode viterbiNode3 = arrayList.get(i);
            int n = viterbiNode3.cost + this.mtx.linkCost(viterbiNode3.rightId, viterbiNode.leftId);
            if (n >= viterbiNode.cost) continue;
            viterbiNode.cost = n;
            viterbiNode.prev = viterbiNode3;
        }
        viterbiNode.cost += this.wdc.cost(viterbiNode.wordId);
        return viterbiNode;
    }

    static {
        BOS_NODES.add(ViterbiNode.makeBOSEOS());
    }
}

