/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.container.BeanDef;
import org.arefgard.container.BusinessDef;
import org.arefgard.container.BusinessService;
import org.arefgard.container.ConnectionDef;
import org.arefgard.container.ContainerException;
import org.arefgard.container.DomainDef;
import org.arefgard.container.IceryaContainer;
import org.arefgard.container.Reference;
import org.arefgard.container.ServiceDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonIceryaContainer
implements IceryaContainer {
    private Log log = LogFactory.getLog(SingletonIceryaContainer.class);
    private ConnectionDef connection = null;
    private Map<String, BusinessDef> services = new HashMap<String, BusinessDef>();
    private Map<String, DomainDef> domains = new HashMap<String, DomainDef>();
    private static SingletonIceryaContainer instance = null;

    private SingletonIceryaContainer() {
    }

    public static IceryaContainer newInstance() {
        if (instance == null) {
            instance = new SingletonIceryaContainer();
        }
        return instance;
    }

    @Override
    public Object create(String ref) throws ContainerException {
        Reference obj = new Reference(ref);
        return this.create(obj);
    }

    @Override
    public Object create(String ref, Map<String, Object> property) throws ContainerException {
        Reference obj = new Reference(ref);
        return this.create(obj, property);
    }

    @Override
    public Object create(Reference ref) throws ContainerException {
        this.log.debug((Object)ref);
        return this.create(ref, null);
    }

    @Override
    public Object create(Reference ref, Map<String, Object> property) throws ContainerException {
        Object result = null;
        if (this.checkService(ref)) {
            BusinessDef businessDef = this.getBusinessDef(ref.getNameSpace());
            ServiceDef serviceDef = businessDef.getServiceDef(ref.getTarget());
            try {
                result = serviceDef.create(property);
            }
            catch (Exception e) {
                this.log.error((Object)"error", (Throwable)e);
            }
        } else {
            DomainDef domainDef = this.getDomainDef(ref.getNameSpace());
            BeanDef beanDef = domainDef.getBeanDef(ref.getTarget());
            try {
                result = beanDef.create(property);
            }
            catch (Exception e) {
                this.log.error((Object)"error", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public Object create(Class clazz) throws ContainerException {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)"error", (Throwable)e);
            throw new ContainerException("error", e);
        }
    }

    @Override
    public BusinessService createService(String path) throws ContainerException {
        Reference ref = new Reference(path);
        BusinessService result = new BusinessService(this, ref);
        return result;
    }

    @Override
    public Object[] find(String query) throws ContainerException {
        return null;
    }

    @Override
    public Object load(String key) throws ContainerException {
        return null;
    }

    @Override
    public void persist(Object obj) throws ContainerException {
    }

    @Override
    public synchronized void addBusinessDef(BusinessDef def) {
        this.services.put(def.getName(), def);
    }

    @Override
    public synchronized BusinessDef getBusinessDef(String key) {
        return this.services.get(key);
    }

    @Override
    public synchronized void addDomainDef(DomainDef def) {
        this.domains.put(def.getName(), def);
    }

    @Override
    public synchronized DomainDef getDomainDef(String key) {
        return this.domains.get(key);
    }

    private boolean checkService(Reference ref) {
        BusinessDef businessDef = this.getBusinessDef(ref.getNameSpace());
        if (businessDef == null) {
            return false;
        }
        return businessDef.contains(ref.getTarget());
    }

    @Override
    public synchronized void setConnectionDef(ConnectionDef connection) {
        this.connection = connection;
    }

    @Override
    public synchronized ConnectionDef getConnectionDef() {
        return this.connection;
    }
}

