/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.container.BeanDef;
import org.arefgard.container.BusinessDef;
import org.arefgard.container.ComponentDef;
import org.arefgard.container.ComponentPropertyDef;
import org.arefgard.container.ConnectionDef;
import org.arefgard.container.ContainerException;
import org.arefgard.container.DomainDef;
import org.arefgard.container.FlowDef;
import org.arefgard.container.IceryaContainer;
import org.arefgard.container.InputDef;
import org.arefgard.container.OutputDef;
import org.arefgard.container.ParameterDef;
import org.arefgard.container.PropertyDef;
import org.arefgard.container.ServiceDef;
import org.arefgard.container.SingletonIceryaContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ContainerFactory {
    private static Log log = LogFactory.getLog(ContainerFactory.class);
    private static String DEFAULT_CONFIG = "components.xml";
    private static String XPATH_NODE_IMPORT = "/container/import";
    private static String XPATH_NODE_JDBC_DRIVER = "/container/connection/property[@name='jdbc.driver']/@value";
    private static String XPATH_NODE_JDBC_URL = "/container/connection/property[@name='jdbc.url']/@value";
    private static String XPATH_NODE_JDBC_USER = "/container/connection/property[@name='jdbc.user']/@value";
    private static String XPATH_NODE_JDBC_PASSWORD = "/container/connection/property[@name='jdbc.password']/@value";
    private static String XPATH_NODE_JDBC_DIALECT = "/container/connection/property[@name='jdbc.dialect']/@value";
    private static String XPATH_NODE_BUSINESS = "/container/business";
    private static String XPATH_NODE_SERVICE = "service";
    private static String XPATH_NODE_DOMAIN = "/container/model";
    private static String XPATH_NODE_INPUT = "input";
    private static String XPATH_NODE_COMPONENT = "component";
    private static String XPATH_NODE_COMPROPERTY = "property";
    private static String XPATH_NODE_QUERY = "query";
    private static String XPATH_NODE_FLOW = "flow";
    private static String XPATH_NODE_PARAMETER = "parameter";
    private static String XPATH_NODE_OUTPUT = "output";
    private static String XPATH_NODE_BEAN = "bean";
    private static String XPATH_NODE_PROPERTY = "property";
    private static String XPATH_ATTR_NAME = "string(@name)";
    private static String XPATH_ATTR_CLASS = "string(@class)";
    private static String XPATH_ATTR_REF = "string(@ref)";
    private static String XPATH_ATTR_TYPE = "string(@type)";
    private static String XPATH_ATTR_TABLE = "string(@table)";
    private static String XPATH_ATTR_COLUMN = "string(@column)";
    private static String XPATH_ATTR_TEXT = "text()";
    private static XPathExpression XPATH_IMPORT;
    private static XPathExpression XPATH_JDBC_DRIVER;
    private static XPathExpression XPATH_JDBC_URL;
    private static XPathExpression XPATH_JDBC_USER;
    private static XPathExpression XPATH_JDBC_PASSWORD;
    private static XPathExpression XPATH_JDBC_DIALECT;
    private static XPathExpression XPATH_BUSINESS;
    private static XPathExpression XPATH_SERVICE;
    private static XPathExpression XPATH_DOMAIN;
    private static XPathExpression XPATH_INPUT;
    private static XPathExpression XPATH_COMPONENT;
    private static XPathExpression XPATH_COMPROPERTY;
    private static XPathExpression XPATH_QUERY;
    private static XPathExpression XPATH_FLOW;
    private static XPathExpression XPATH_PARAMETER;
    private static XPathExpression XPATH_OUTPUT;
    private static XPathExpression XPATH_BEAN;
    private static XPathExpression XPATH_PROPERTY;
    private static XPathExpression XPATH_NAME;
    private static XPathExpression XPATH_CLASS;
    private static XPathExpression XPATH_REF;
    private static XPathExpression XPATH_TYPE;
    private static XPathExpression XPATH_TABLE;
    private static XPathExpression XPATH_COLUMN;
    private static XPathExpression XPATH_TEXT;
    private static boolean isInitialized;

    static {
        isInitialized = false;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            XPATH_IMPORT = xpath.compile(XPATH_NODE_IMPORT);
            XPATH_JDBC_DRIVER = xpath.compile(XPATH_NODE_JDBC_DRIVER);
            XPATH_JDBC_URL = xpath.compile(XPATH_NODE_JDBC_URL);
            XPATH_JDBC_USER = xpath.compile(XPATH_NODE_JDBC_USER);
            XPATH_JDBC_PASSWORD = xpath.compile(XPATH_NODE_JDBC_PASSWORD);
            XPATH_JDBC_DIALECT = xpath.compile(XPATH_NODE_JDBC_DIALECT);
            XPATH_BUSINESS = xpath.compile(XPATH_NODE_BUSINESS);
            XPATH_SERVICE = xpath.compile(XPATH_NODE_SERVICE);
            XPATH_DOMAIN = xpath.compile(XPATH_NODE_DOMAIN);
            XPATH_INPUT = xpath.compile(XPATH_NODE_INPUT);
            XPATH_COMPONENT = xpath.compile(XPATH_NODE_COMPONENT);
            XPATH_COMPROPERTY = xpath.compile(XPATH_NODE_COMPROPERTY);
            XPATH_QUERY = xpath.compile(XPATH_NODE_QUERY);
            XPATH_FLOW = xpath.compile(XPATH_NODE_FLOW);
            XPATH_PARAMETER = xpath.compile(XPATH_NODE_PARAMETER);
            XPATH_OUTPUT = xpath.compile(XPATH_NODE_OUTPUT);
            XPATH_BEAN = xpath.compile(XPATH_NODE_BEAN);
            XPATH_PROPERTY = xpath.compile(XPATH_NODE_PROPERTY);
            XPATH_NAME = xpath.compile(XPATH_ATTR_NAME);
            XPATH_CLASS = xpath.compile(XPATH_ATTR_CLASS);
            XPATH_REF = xpath.compile(XPATH_ATTR_REF);
            XPATH_TYPE = xpath.compile(XPATH_ATTR_TYPE);
            XPATH_TABLE = xpath.compile(XPATH_ATTR_TABLE);
            XPATH_COLUMN = xpath.compile(XPATH_ATTR_COLUMN);
            XPATH_TEXT = xpath.compile(XPATH_ATTR_TEXT);
        }
        catch (Exception e) {
            log.error((Object)"XPath\u5f0f\u306e\u30b3\u30f3\u30d1\u30a4\u30eb\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
        }
    }

    public static void initialize() throws ContainerException {
        ContainerFactory.initialize(DEFAULT_CONFIG);
    }

    public static void initialize(String name) throws ContainerException {
        if (ContainerFactory.isInitialized()) {
            return;
        }
        ContainerFactory.init(name);
    }

    private static void init(String name) throws ContainerException {
        IceryaContainer socContainer = ContainerFactory.newContainer();
        log.debug((Object)("\u8aad\u307f\u8fbc\u307f\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb:" + name));
        InputStream is = ClassLoader.getSystemResourceAsStream(name);
        if (is == null && (is = ClassLoader.getSystemResourceAsStream(DEFAULT_CONFIG)) == null) {
            throw new ContainerException("\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb:" + name + "\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
        }
        Document doc = ContainerFactory.parseDocument(is);
        try {
            ContainerFactory.parseImport(doc);
            ConnectionDef connectionDef = new ConnectionDef();
            connectionDef.setDriver(((Node)XPATH_JDBC_DRIVER.evaluate(doc, XPathConstants.NODE)).getNodeValue());
            connectionDef.setUrl(((Node)XPATH_JDBC_URL.evaluate(doc, XPathConstants.NODE)).getNodeValue());
            connectionDef.setUser(((Node)XPATH_JDBC_USER.evaluate(doc, XPathConstants.NODE)).getNodeValue());
            connectionDef.setPassword(((Node)XPATH_JDBC_PASSWORD.evaluate(doc, XPathConstants.NODE)).getNodeValue());
            connectionDef.setDialect(((Node)XPATH_JDBC_DIALECT.evaluate(doc, XPathConstants.NODE)).getNodeValue());
            socContainer.setConnectionDef(connectionDef);
            ContainerFactory.parseBusinessDomain(socContainer, doc);
            ContainerFactory.parseDomainModel(socContainer, doc);
        }
        catch (ContainerException e) {
            log.error((Object)"Bean\u304c\u5b58\u5728\u3057\u307e\u305b\u3093", (Throwable)e);
            throw e;
        }
        catch (XPathExpressionException e) {
            log.error((Object)"XPath\u5f0f\u306e\u30b3\u30f3\u30d1\u30a4\u30eb\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
            throw new ContainerException("XPath\u5f0f\u306e\u30b3\u30f3\u30d1\u30a4\u30eb\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
        catch (Exception e) {
            log.error((Object)"\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", (Throwable)e);
            throw new ContainerException("\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
        isInitialized = true;
    }

    private static void parseImport(Document doc) throws XPathExpressionException, ContainerException {
        NodeList importNodes = (NodeList)XPATH_IMPORT.evaluate(doc, XPathConstants.NODESET);
        int importLen = importNodes.getLength();
        int i = 0;
        while (i < importLen) {
            Node importNode = importNodes.item(i);
            log.debug((Object)("\u30a4\u30f3\u30dd\u30fc\u30c8\u767a\u898b\uff1a" + ContainerFactory.getRef(importNode)));
            ContainerFactory.init(ContainerFactory.getRef(importNode));
            ++i;
        }
    }

    private static void parseBusinessDomain(IceryaContainer socContainer, Document doc) throws XPathExpressionException, ContainerException {
        NodeList businessNodes = (NodeList)XPATH_BUSINESS.evaluate(doc, XPathConstants.NODESET);
        int businessLen = businessNodes.getLength();
        int i = 0;
        while (i < businessLen) {
            Node businessNode = businessNodes.item(i);
            String businessName = ContainerFactory.getName(businessNode);
            log.debug((Object)("\u30d3\u30b8\u30cd\u30b9\u30c9\u30e1\u30a4\u30f3\u767a\u898b:" + businessName));
            BusinessDef business = new BusinessDef(businessName);
            NodeList serviceNodes = (NodeList)XPATH_SERVICE.evaluate(businessNode, XPathConstants.NODESET);
            int serviceLen = serviceNodes.getLength();
            int j = 0;
            while (j < serviceLen) {
                Node serviceNode = serviceNodes.item(j);
                String serviceName = ContainerFactory.getName(serviceNode);
                log.debug((Object)("\u30b5\u30fc\u30d3\u30b9\u767a\u898b:" + serviceName));
                ServiceDef service = new ServiceDef(serviceName);
                NodeList inputNodes = (NodeList)XPATH_INPUT.evaluate(serviceNode, XPathConstants.NODESET);
                int inputLen = inputNodes.getLength();
                int k = 0;
                while (k < inputLen) {
                    Node inputNode = inputNodes.item(k);
                    String inputName = ContainerFactory.getName(inputNode);
                    String inputClass = ContainerFactory.getClass(inputNode);
                    log.debug((Object)("input\u767a\u898b:" + inputName + "," + inputClass));
                    service.addInputDef(new InputDef(inputName, inputClass));
                    ++k;
                }
                NodeList componentNodes = (NodeList)XPATH_COMPONENT.evaluate(serviceNode, XPathConstants.NODESET);
                int componentLen = inputNodes.getLength();
                int k2 = 0;
                while (k2 < componentLen) {
                    Node componentNode = componentNodes.item(k2);
                    String componentName = ContainerFactory.getName(componentNode);
                    String componentRef = ContainerFactory.getRef(componentNode);
                    log.debug((Object)("component\u767a\u898b:" + componentName + "," + componentRef));
                    ComponentDef componentDef = new ComponentDef(componentName, componentRef);
                    NodeList propertyNodes = (NodeList)XPATH_COMPROPERTY.evaluate(componentNode, XPathConstants.NODESET);
                    int propertyLen = propertyNodes.getLength();
                    int l = 0;
                    while (l < propertyLen) {
                        Node propertyNode = propertyNodes.item(l);
                        String propertyName = ContainerFactory.getName(propertyNode);
                        String propertyValue = ContainerFactory.getText(propertyNode);
                        log.debug((Object)("property\u767a\u898b:" + propertyName + "," + propertyValue));
                        componentDef.addPropertyDef(new ComponentPropertyDef(propertyName, propertyValue));
                        ++l;
                    }
                    Node queryNode = (Node)XPATH_QUERY.evaluate(componentNode, XPathConstants.NODE);
                    String query = ContainerFactory.getText(queryNode);
                    if (query != null && !query.equals("")) {
                        log.debug((Object)("query\u767a\u898b:" + query));
                        componentDef.setQuery(query);
                    }
                    service.addComponentDef(componentDef);
                    ++k2;
                }
                Node flowNode = (Node)XPATH_FLOW.evaluate(serviceNode, XPathConstants.NODE);
                String flowName = ContainerFactory.getName(flowNode);
                FlowDef flowDef = new FlowDef(flowName);
                log.debug((Object)("flow\u767a\u898b:" + flowName));
                NodeList parameterNodes = (NodeList)XPATH_PARAMETER.evaluate(flowNode, XPathConstants.NODESET);
                int parameterLen = parameterNodes.getLength();
                int k3 = 0;
                while (k3 < parameterLen) {
                    Node parameterNode = parameterNodes.item(k3);
                    String parameterName = ContainerFactory.getName(parameterNode);
                    String parameterRef = ContainerFactory.getRef(parameterNode);
                    log.debug((Object)("parameter\u767a\u898b:" + parameterName + "," + parameterRef));
                    flowDef.addParameterDef(new ParameterDef(parameterName, parameterRef));
                    ++k3;
                }
                service.setFlowDef(flowDef);
                NodeList outputNodes = (NodeList)XPATH_OUTPUT.evaluate(serviceNode, XPathConstants.NODESET);
                int outputLen = outputNodes.getLength();
                int k4 = 0;
                while (k4 < outputLen) {
                    Node outputNode = outputNodes.item(k4);
                    String outputName = ContainerFactory.getName(outputNode);
                    String outputRef = ContainerFactory.getRef(outputNode);
                    log.debug((Object)("output\u767a\u898b:" + outputName + "," + outputRef));
                    service.addOutputDef(new OutputDef(outputName, outputRef));
                    ++k4;
                }
                business.addServiceDef(service);
                ++j;
            }
            socContainer.addBusinessDef(business);
            ++i;
        }
    }

    private static void parseDomainModel(IceryaContainer socContainer, Document doc) throws XPathExpressionException, ContainerException {
        NodeList domainNodes = (NodeList)XPATH_DOMAIN.evaluate(doc, XPathConstants.NODESET);
        int domainLen = domainNodes.getLength();
        int i = 0;
        while (i < domainLen) {
            Node domainNode = domainNodes.item(i);
            DomainDef domain = new DomainDef(ContainerFactory.getName(domainNode));
            NodeList beanNodes = ContainerFactory.getBean(domainNode);
            int beanLen = beanNodes.getLength();
            int j = 0;
            while (j < beanLen) {
                Node beanNode = beanNodes.item(j);
                String beanName = ContainerFactory.getName(beanNode);
                String beanClass = ContainerFactory.getClass(beanNode);
                String beanTable = ContainerFactory.getTable(beanNode);
                log.debug((Object)("Bean\u767a\u898b\uff1a" + beanName + "," + beanClass + "," + beanTable));
                BeanDef bean = new BeanDef(beanName, beanClass);
                bean.setTable(beanTable);
                NodeList propNodes = ContainerFactory.getProperty(beanNode);
                int propLen = propNodes.getLength();
                int k = 0;
                while (k < propLen) {
                    Node propNode = propNodes.item(k);
                    String propName = ContainerFactory.getName(propNode);
                    String propType = ContainerFactory.getType(propNode);
                    String propColumn = ContainerFactory.getColumn(propNode);
                    log.debug((Object)("Property\u767a\u898b:" + propName + "," + propType + "," + propColumn));
                    bean.addProperty(new PropertyDef(propName, propType, propColumn));
                    ++k;
                }
                domain.addBeanDef(bean);
                ++j;
            }
            socContainer.addDomainDef(domain);
            ++i;
        }
    }

    private static Document parseDocument(InputStream is) throws ContainerException {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(is);
        }
        catch (SAXException e) {
            log.error((Object)"\u69cb\u6210\u30d5\u30a1\u30a4\u30eb\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
            throw new ContainerException("\u69cb\u6210\u30d5\u30a1\u30a4\u30eb\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"XML\u30d1\u30fc\u30b5\u306e\u69cb\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
            throw new ContainerException("XML\u30d1\u30fc\u30b5\u306e\u69cb\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
        catch (IOException e) {
            log.error((Object)"XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
            throw new ContainerException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
        return doc;
    }

    private static synchronized boolean isInitialized() {
        return isInitialized;
    }

    private static NodeList getBean(Object obj) throws XPathExpressionException {
        return (NodeList)XPATH_BEAN.evaluate(obj, XPathConstants.NODESET);
    }

    private static NodeList getProperty(Object obj) throws XPathExpressionException {
        return (NodeList)XPATH_PROPERTY.evaluate(obj, XPathConstants.NODESET);
    }

    private static String getName(Object obj) throws XPathExpressionException {
        return (String)XPATH_NAME.evaluate(obj, XPathConstants.STRING);
    }

    private static String getClass(Object obj) throws XPathExpressionException {
        return (String)XPATH_CLASS.evaluate(obj, XPathConstants.STRING);
    }

    private static String getRef(Object obj) throws XPathExpressionException {
        return (String)XPATH_REF.evaluate(obj, XPathConstants.STRING);
    }

    private static String getType(Object obj) throws XPathExpressionException {
        return (String)XPATH_TYPE.evaluate(obj, XPathConstants.STRING);
    }

    private static String getTable(Object obj) throws XPathExpressionException {
        return (String)XPATH_TABLE.evaluate(obj, XPathConstants.STRING);
    }

    private static String getColumn(Object obj) throws XPathExpressionException {
        return (String)XPATH_COLUMN.evaluate(obj, XPathConstants.STRING);
    }

    private static String getText(Object obj) throws XPathExpressionException {
        return (String)XPATH_TEXT.evaluate(obj, XPathConstants.STRING);
    }

    public static IceryaContainer newContainer() throws ContainerException {
        IceryaContainer container = SingletonIceryaContainer.newInstance();
        return container;
    }
}

