/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arefgard.container.ContainerException;
import org.arefgard.container.Property;
import org.arefgard.container.PropertyDef;
import org.arefgard.container.aop.ClassGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDef {
    private String name;
    private String className;
    private String table;
    private Map<String, PropertyDef> property = new HashMap<String, PropertyDef>();

    public BeanDef(String name, String className) throws ContainerException {
        this.name = name;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addProperty(PropertyDef propertyDef) {
        this.property.put(propertyDef.getName(), propertyDef);
    }

    public PropertyDef getProperty(String name) {
        return this.property.get(name);
    }

    public PropertyDef[] getAllProperties() {
        return this.property.values().toArray(new PropertyDef[0]);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public Object create(List<Property> property) throws Exception {
        Object newObj = null;
        if (property != null && property.size() != 0) {
            int length = property.size();
            String[] typelist = new String[length];
            Object[] objlist = new Object[length];
            int i = 0;
            while (i < length) {
                typelist[i] = property.get(i).getType();
                objlist[i] = property.get(i).getValue();
                ++i;
            }
            newObj = ClassGenerator.generate(this.className, typelist, objlist);
        } else {
            newObj = ClassGenerator.generate(this.className);
        }
        return newObj;
    }

    public Object create(Map<String, Object> property) throws Exception {
        Object newObj = null;
        newObj = property != null && property.size() != 0 ? ClassGenerator.generate(this.className, property) : ClassGenerator.generate(this.className);
        return newObj;
    }
}

