package org.arefgard.container.aop;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.List;

import org.junit.Before;
import org.junit.Test;


public class MethodInvocationTest {
	
	private MethodInvocation invocation;
	private TargetClass obj;
	
	@Before
	public void setUp() {
		obj = new TargetClass();
		invocation = new MethodInvocation(obj);
	}
	
	@Test
	public void setPropertyAndGetProperty() {
		try {
			String value1 = "hoge";
			int value2 = 100;
			invocation.setProperty("value1", value1);
			invocation.setProperty("value2", value2);
			assertEquals(value1, invocation.getProperty("value1"));
			assertEquals(value2, invocation.getProperty("value2"));
		}catch(Exception e) {
			e.printStackTrace();
			fail("例外が発生しました" + e);
		}
	}
	
	@Test
	public void executeMethod() {
		try {
			String result = (String)invocation.execute("hoge", null);
			assertEquals("hoge", result);
		}catch(Exception e) {
			e.printStackTrace();
			fail("例外が発生しました" + e);
		}
	}
	
	@Test
	public void executeMethodWithArgument() {
		try {
			List<Object> args = new java.util.ArrayList<Object>();
			args.add("bar");
			String result = (String)invocation.execute("hoge", args);
			assertEquals("hogebar", result);
		}catch(Exception e) {
			e.printStackTrace();
			fail("例外が発生しました" + e);
		}
	}
}

class TargetClass {
	private String value1;
	private int value2;
	
	public String getValue1() {
		return value1;
	}
	public void setValue1(String value1) {
		this.value1 = value1;
	}
	public int getValue2() {
		return value2;
	}
	public void setValue2(int value2) {
		this.value2 = value2;
	}
	
	public String hoge() {
		return "hoge";
	}
	
	public String hoge(String value) {
		return "hoge" + value;
	}
	
}
