package org.arefgard.container.flow;

public interface WorkflowExecutor {
	
	/**
	 * ワークフローを実行する。
	 */
	public void execute() throws Exception;
	
	/**
	 * 入力パラメータを設定する。
	 * 
	 * @param key 入力キー
	 * @param obj パラメータ
	 */
	public void setInput(String key, Object obj);
	
	/**
	 * 出力を得る。
	 * 
	 * @param key 出力キー
	 * @return 出力
	 */
	public Object getOutput(String key);
}
