#ifndef TYPING_TEXT_CONVERTER_H
#define TYPING_TEXT_CONVERTER_H

/*!
  \file
  \brief ^CsOp̓{ϊ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "TextConvertInterface.h"
#include <memory>

class TypingRecorder;

/*!
  \brief ͕̕ϊ
*/
class TypingTextConverter : public TextConvertInterface {
  TypingTextConverter(void);
  TypingTextConverter(const TypingTextConverter& rhs);
  TypingTextConverter& operator = (const TypingTextConverter& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

 public:

  /*!
    \brief ̓[h
  */
  typedef enum {
    Roman,                      //!< [}
    Kana,                       //!< ȓ
  } ConvertType;

  /*!
    \brief ̓[hw̃RXgN^

    \param type [i] ̓[h
  */
  TypingTextConverter(ConvertType type);
  ~TypingTextConverter(void);

  void clear(void);
  void setConvertBuffer(const std::vector<Uint16>& text);
  void getConvertBuffer(std::vector<Uint16>& buffer);
  bool addChar(char ch);
  bool moveLeft(void);
  bool moveRight(void);
  bool moveUp(void);
  bool moveDown(void);
  bool escapePressed(void);
  bool deleteBack(void);
  bool deleteCurrent(void);
  bool convertInput(void);

  /*!
    \brief L^IuWFNg̓o^

    \param recorder [i] o^p̃IuWFNg
  */
  void registerRecorder(TypingRecorder* recorder);

  /*!
    \brief Jn^C~O̓o^

    \param start_ticks [i] Jn^C~O
  */
  void registerStartTicks(size_t start_ticks);

  ConvertType getConvertType(void);
};

#endif /* !TYPING_TEXT_CONVERTER_H */
