/*!
  \file
  \brief [Uj[

  \author Satofumi KAMIMURA

  $Id$

  \todo [UǉA폜ꂽAIĂ郆[UύX
  \todo [UǉꂽAR{{bNX̑IÃ[UɕύX
  \todo ̃j[ł́A[UύX̃R{{bNXւ̑͗Lɂ
  \todo [U{^炱̃j[ɑJڂ悤ɂ
*/

#include "UserMenu.h"
#include "UserMenu_uni.h"
#include "ResourceDefinition.h"
#include "DrawsDefinition.h"
#include "CommonResources.h"
#include "CreateUser.h"
#include "RemoveUser.h"
#include "GuiManager.h"
#include "Layer.h"
#include "TextProperty.h"
#include "TextSurface.h"
#include "LabelComponent.h"
#include "InputHandler.h"
#include "ButtonComponent.h"
#include "MenuComponent.h"
#include "SoundEffectManager.h"
#include "SdlUtils.h"
#include "Delay.h"

using namespace beego;


struct UserMenu::pImpl {
  CommonResources* common;
  TextProperty text_property;
  Surface title_surface;
  Component title_label;
  boost::shared_ptr<MenuComponent> menu;

  pImpl(void)
    : common(CommonResources::getObject()),
      text_property(common->font, UserMenu_title, TitleSize, Fore, Back, true),
      title_surface(new TextSurface(text_property)),
      title_label(new LabelComponent(title_surface)),
      menu(new MenuComponent) {

    // ^Cg̔zu
    SDL_Rect position;
    set_SdlRect(&position, centerPosition(title_label, 640/2),
                middlePosition(title_label, 480/4));
    title_label->setPosition(&position);

    // j[ڂ̍쐬
    const Uint16 *titles[] = {
      UserMenu_add, UserMenu_delete, UserMenu_back,
    };

    size_t max_width = 0;
    for (size_t i = 0; i < sizeof(titles)/sizeof(titles[0]); ++i) {
      boost::shared_ptr<ButtonComponent> new_button(new ButtonComponent);
      TextProperty normal(common->font, titles[i], MenuSize,
                          Fore, Back, true);
      TextProperty selected(common->font, titles[i], MenuSize,
                            Selected, Back, true);
      ButtonComponent::createButton(new_button, normal, selected, selected);
      if (new_button->getWidth() > max_width) {
        max_width = new_button->getWidth();
      }
      menu->addItem(new_button);
    }
    menu->setItemsOffset(0, MenuSize + 16);
    menu->setItemSelectWidth(max_width);
    menu->setSelected(0);

    set_SdlRect(&position, centerPosition(menu, 640/2), 480/4 + MenuOffset);
    menu->setPosition(&position);
  }

  void placeComponents(void) {
    common->front_layer->push_front(title_label);
    common->front_layer->push_front(menu);
  }

  void removeComponents(void) {
    common->front_layer->remove(title_label);
    common->front_layer->remove(menu);
  }
};


UserMenu::UserMenu(void) : pimpl(new pImpl) {
  pimpl->placeComponents();
}


UserMenu::~UserMenu(void) {
  pimpl->removeComponents();
}


void UserMenu::run(void) {

  GuiManager* gui = pimpl->common->gui;
  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  while (quit == false) {

    // !!! IɁA[U쐬Ɉړ悤ɂ
    int selected = pimpl->menu->getDecided();
    if (0 || selected >= 0) {
      //selected = 0;

      // !!! Ƃ肠AŌ艹炷
      // !!! Is\ȍڂ肵ƂɉςȂAύX
      if (pimpl->common->music) {
        pimpl->common->sound_effect->play(Decide);
      }

      pimpl->removeComponents();
      if (selected == 0) {
        // VK[U̍쐬
        CreateUser create_user;
        create_user.run();

      } else if (selected == 1) {
        // [U̍폜
        RemoveUser remove_user;
        remove_user.run();

      } else if (selected == 2) {
        // ߂
        return;
      }

      // j[đI\ɂ
      pimpl->placeComponents();
      pimpl->menu->releaseDecided();
    }

    input.update_all();
    gui->update();
    quit |= input.haveQuitEvent() | input.isReleased(SDLK_ESCAPE);
    delay(1);
  }
}
