/*!
  \file
  \brief lbg[Ñj[

  \author Satofumi KAMIMURA

  $Id$

  \todo uΐf[^̉{vǉ
*/

#include "NetworkMenu.h"
#include "NetworkMenu_uni.h"
#include "DrawsDefinition.h"
#include "ResourceDefinition.h"
#include "CommonResources.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputHandler.h"
#include "TextSurface.h"
#include "TextProperty.h"
#include "LabelComponent.h"
#include "MenuComponent.h"
#include "ButtonComponent.h"
#include "SoundEffectManager.h"
#include "SdlUtils.h"
#include "Delay.h"

using namespace beego;


struct NetworkMenu::pImpl {
  CommonResources* common;
  TtfResource* font;
  TextProperty title_property;
  Surface title_surface;
  Component title_label;
  boost::shared_ptr<MenuComponent> menu;

  pImpl(void)
    : common(CommonResources::getObject()),
      title_property(common->font, NetworkMenu_title, TitleSize,
                     Fore, Back, true),
      title_surface(new TextSurface(title_property)),
      title_label(new LabelComponent(title_surface)), menu(new MenuComponent) {

    // ^Cg̈ʒuݒ
    SDL_Rect position;
    set_SdlRect(&position, centerPosition(title_label, 640/2),
                middlePosition(title_label, 480/4));
    title_label->setPosition(&position);

    // j[̐Aʒuݒ
    // j[̍ڂ쐬
    const Uint16 *titles[] = {
      NetworkMenu_player, NetworkMenu_data, NetworkMenu_back,
    };

    size_t max_width = 0;
    for (size_t i = 0; i < sizeof(titles)/sizeof(titles[0]); ++i) {
      boost::shared_ptr<ButtonComponent> new_button(new ButtonComponent);
      TextProperty normal(common->font, titles[i], MenuSize,
                          Fore, Back, true);
      TextProperty selected(common->font, titles[i], MenuSize,
                            Selected, Back, true);
      ButtonComponent::createButton(new_button, normal, selected, selected);
      if (new_button->getWidth() > max_width) {
        max_width = new_button->getWidth();
      }
      menu->addItem(new_button);
    }
    menu->setItemsOffset(0, MenuSize + 16);
    menu->setItemSelectWidth(max_width);
    menu->setSelected(0);

    set_SdlRect(&position, centerPosition(menu, 640/2),        480/4 + MenuOffset);
    menu->setPosition(&position);
  }

  void placeComponents(void) {
    common->front_layer->push_front(title_label);
    common->front_layer->push_front(menu);
  }

  void removeComponents(void) {
    common->front_layer->remove(title_label);
    common->front_layer->remove(menu);
  }
};


NetworkMenu::NetworkMenu(void) : pimpl(new pImpl) {
  pimpl->placeComponents();
}


NetworkMenu::~NetworkMenu(void) {
  pimpl->removeComponents();
}


void NetworkMenu::run(void) {

  GuiManager* gui = pimpl->common->gui;
  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  while (quit == false) {

    int selected = pimpl->menu->getDecided();
    if (selected >= 0) {

      // !!! Ƃ肠AŌ艹炷
      // !!! Is\ȍڂ肵ƂɉςȂAύX
      if (pimpl->common->music) {
        pimpl->common->sound_effect->play(Decide);
      }

      pimpl->removeComponents();
      if (selected == 0) {
        // ΐl
        // !!!

      } else if (selected == 1) {
        // ߋf[^Ƃ̑ΐ
        // !!!

      } else if (selected == 2) {
        // ߂
        quit |= true;
      }

      // j[đI\ɂ
      pimpl->placeComponents();
      pimpl->menu->releaseDecided();
    }

    input.update_all();
    gui->update();
    quit |= input.isReleased(SDLK_ESCAPE);
    if (input.haveQuitEvent()) {
      pimpl->common->front_layer->disable();
      quit |= true;
    }
    delay(1);
  }
}
