#ifndef HORIZONTAL_SELECT_COMPONENT_H
#define HORIZONTAL_SELECT_COMPONENT_H

/*!
  \file
  \brief ZN^

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ComponentInterface.h"
#include <memory>


namespace beego {
  class TextProperty;

  class HorizontalSelectComponent : public ComponentInterface {
    HorizontalSelectComponent(void);
    HorizontalSelectComponent(const HorizontalSelectComponent& rhs);
    HorizontalSelectComponent& operator = (const HorizontalSelectComponent&
                                           rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    typedef enum {
      BackColor,
      UnderBar,
    } SelectMode;
    explicit HorizontalSelectComponent(const TextProperty& text_property,
                                       Uint32 active_color,
                                       SelectMode mode = BackColor);

    ~HorizontalSelectComponent(void);

    void addSurfaceList(SurfaceList& surfaces, const SDL_Rect* area,
                        size_t ticks);
    void setPosition(const SDL_Rect* position);
    void getPosition(SDL_Rect* position);
    size_t getWidth(void);
    size_t getHeight(void);
    void applyInput(const InputEvent& event,
                    std::vector<SDL_Rect>& applied_rects);
    void registerLayer(Layer* layer);

    // !!! ڂǉ
    void addItem(const char* text);
    //void addItem(const Uint16* utext);
    void setItemsOffset(int x_offset);
    void setSelected(int index);
    void enableInput(void);
    void disableInput(void);

    // !!! ڂ̊Ԋuݒ
    // !!! A_[o[ or wiFw
  };
};

#endif /* !HORIZONTAL_SELECT_COMPONENT_H */
