/*!
  \file
  \brief ZN^

  \author Satofumi KAMIMURA

  $Id$
*/

#include "HorizontalSelectComponent.h"
#include "TtfResource.h"
#include "TextProperty.h"
#include "TextSurface.h"
#include "SwitchSurface.h"
#include "Component.h"
#include "SdlUtils.h"

using namespace beego;


struct HorizontalSelectComponent::pImpl {
  enum {
    InvalidIndex = -1,
    Normal = 0,
    Active,
  };
  SDL_Rect position;
  bool position_changed;
  TtfResource* font;
  size_t font_size;
  Uint32 fore_active;
  Uint32 fore_normal;
  Uint32 back;
  bool is_transparent;
  SelectMode mode;
  typedef std::vector<boost::shared_ptr<SwitchSurface> > ItemSurfaces;
  ItemSurfaces surfaces;
  std::vector<DrawSurface> draw_surfaces;
  size_t items_offset;
  int now_index;
  bool input_enable;

  pImpl(const TextProperty& text_property,
        Uint32 active_color, SelectMode mode_)
    : position_changed(false),
      font(text_property.font), font_size(text_property.size),
      fore_active(active_color), fore_normal(text_property.fore_color),
      back(text_property.back_color), is_transparent(text_property.transparent),
      mode(mode_), items_offset(0), now_index(InvalidIndex),
      input_enable(true) {

    set_SdlRect(&position, 0, 0, 0, 0);
  }

  void updateSize(void) {

    size_t total_width = 0;
    size_t max_height = 0;

    for (ItemSurfaces::iterator it = surfaces.begin();
         it != surfaces.end(); ++it) {

      size_t width = (*it)->getWidth();
      total_width += width + items_offset;

      size_t height = (*it)->getHeight();
      if (height > max_height) {
        max_height = height;
      }
    }
    total_width -= items_offset;

    position.w = total_width;
    position.h = max_height;

    DrawSurface dummy;
    draw_surfaces.push_back(dummy);
  }

  void changeSelector(int next_index) {

    if (now_index >= 0) {
      // T[tFXʏT[tFXɖ߂
      surfaces[now_index]->switchSurface(pImpl::Normal);
    }

    // T[tFX̕ύX
    if (next_index >= 0) {
      // T[tFXύXAĕ`𑣂
      surfaces[next_index]->switchSurface(pImpl::Active);
    }

    now_index = next_index;
    position_changed = true;
  }
};


HorizontalSelectComponent::HorizontalSelectComponent(const TextProperty&
                                                     text_property,
                                                     Uint32 active_color,
                                                     SelectMode mode)
  : pimpl(new pImpl(text_property, active_color, mode)) {
}


HorizontalSelectComponent::~HorizontalSelectComponent(void) {
}


void HorizontalSelectComponent::addSurfaceList(SurfaceList& surfaces,
                                               const SDL_Rect* area,
                                               size_t ticks) {

  SDL_Rect surface_position = pimpl->position;
  size_t index = 0;
  for (pImpl::ItemSurfaces::iterator it = pimpl->surfaces.begin();
       it != pimpl->surfaces.end(); ++it, ++index) {

    size_t width = (*it)->getWidth();
    size_t height = (*it)->getHeight();

    surface_position.w = width;
    surface_position.h = height;

    //fprintf(stderr, "%d, %d, %d, %d, %d\n", surface_position.x, surface_position.y, surface_position.h, surface_position.w, pimpl->position.w);

    updateDrawSurface(pimpl->draw_surfaces[index], *it, area,
                      surface_position, pimpl->position_changed);
    surfaces.push_back(&pimpl->draw_surfaces[index]);

    surface_position.x += width + pimpl->items_offset;
  }
  pimpl->position_changed = false;
}


void HorizontalSelectComponent::setPosition(const SDL_Rect* position) {
  set_SdlRect(&pimpl->position, position->x, position->y,
              pimpl->position.w, pimpl->position.h);
  pimpl->position_changed = true;
}


void HorizontalSelectComponent::getPosition(SDL_Rect* position) {
  *position = pimpl->position;
}


size_t HorizontalSelectComponent::getWidth(void) {
  return pimpl->position.w;
}


size_t HorizontalSelectComponent::getHeight(void) {
  return pimpl->position.h;
}


void HorizontalSelectComponent::applyInput(const InputEvent& event,
                                           std::vector<SDL_Rect>&
                                           applied_rects) {
  if (! pimpl->input_enable) {
    return;
  }

  // ẼJ[\͂őIړ
  // !!!

  // }EXJ[\̃tH[JXꏊɑIړ
  // !!!
}


void HorizontalSelectComponent::registerLayer(Layer* layer) {
}


void HorizontalSelectComponent::addItem(const char* text) {

  TextProperty property(pimpl->font, text, pimpl->font_size,
                        pimpl->fore_normal, pimpl->back, pimpl->is_transparent);
  Surface normal_surface(new TextSurface(property));

  property.back_color = pimpl->fore_active;
  property.transparent = false;
  Surface active_surface(new TextSurface(property));

  boost::shared_ptr<SwitchSurface> switch_surface(new SwitchSurface);
  switch_surface->registerSurface(normal_surface, 0, 0, pImpl::Normal);
  switch_surface->registerSurface(active_surface, 0, 0, pImpl::Active);
  switch_surface->switchSurface(0);

  pimpl->surfaces.push_back(switch_surface);
  pimpl->updateSize();
}


#if 0
void HorizontalSelectComponent::addItem(const Uint16* utext) {
}
#endif


void HorizontalSelectComponent::setItemsOffset(int x_offset) {
  pimpl->items_offset = x_offset;
  pimpl->updateSize();
}


void HorizontalSelectComponent::setSelected(int index) {

  if ((index < static_cast<int>(pimpl->surfaces.size())) &&
      (pimpl->now_index != index)) {
    pimpl->changeSelector(index);
  }
}


void HorizontalSelectComponent::enableInput(void) {
  pimpl->input_enable = true;
}


void HorizontalSelectComponent::disableInput(void) {
  pimpl->input_enable = false;
}
