/*!
  \file
  \brief Ñj[

  \author Satofumi KAMIMURA

  $Id$

  \todo IĂ鍀ڂɁAACRt
  \todo |bvAbvŃj[ڂ̐s
  \todo R{{bNXŃ[U\
  \todo u^CsỎ{v̕t
  \todo j[̐
*/

#include "FirstMenu.h"
#include "FirstMenu_uni.h"
#include "hyakutyping.h"
#include "DrawsDefinition.h"
#include "CommonResources.h"
#include "ResourceDefinition.h"
#include "PracticeMenu.h"
#include "NetworkMenu.h"
#include "OptionMenu.h"
#include "UserMenu.h"
#include "GuiManager.h"
#include "user_bmp.h"
#include "Layer.h"
#include "SdlSurface.h"
#include "TextSurface.h"
#include "TextProperty.h"
#include "LabelComponent.h"
#include "ButtonComponent.h"
#include "MenuComponent.h"
#include "ComboBoxComponent.h"
#include "InputHandler.h"
#include "CreateSurfaceFromArray.h"
#include "MusicManager.h"
#include "SoundEffectManager.h"
#include "SdlUtils.h"
#include "Delay.h"

using namespace beego;


struct FirstMenu::pImpl {
  CommonResources* common;
  TtfResource* font;
  TextProperty title_property;
  Surface title_surface;
  Component title_label;
  boost::shared_ptr<MenuComponent> menu;
  TextProperty version_property;
  Surface version_surface;
  Component version_label;
  boost::shared_ptr<ComboBoxComponent> user_combobox;

  // !!! Ƃ肠A摜ƂĒt
  Surface user_bmp_surface;
  Component user_label;

  pImpl(void)
    : common(CommonResources::getObject()),
      title_property(common->font, FirstMenu_title, TitleSize,
                     Fore, Back, true),
      title_surface(new TextSurface(title_property)),
      title_label(new LabelComponent(title_surface)), menu(new MenuComponent),
      version_property(common->font, VersionText, NormalSize,
                       Fore, Back, true),
      version_surface(new TextSurface(version_property)),
      version_label(new LabelComponent(version_surface)),
      user_bmp_surface(new SdlSurface(createSurface(user_bmp,
						    user_bmp_width,
						    user_bmp_height), true)),
      user_label(new LabelComponent(user_bmp_surface))
  {

    // o[Ẅʒuݒ
    SDL_Rect position;
    set_SdlRect(&position, TextOffset, TextOffset);
    version_label->setPosition(&position);

    // ^Cg̈ʒuݒ
    set_SdlRect(&position, centerPosition(title_label, 640/2),
                middlePosition(title_label, 480/4));
    title_label->setPosition(&position);

    // j[ڂ̍쐬
    const Uint16 *titles[] = {
      FirstMenu_practice, FirstMenu_network, FirstMenu_user,
      FirstMenu_option, FirstMenu_quit,
    };

    // !!! ̃j[鏈́ACommonResource ̊֐ŏ悤
    size_t max_width = 0;
    for (size_t i = 0; i < sizeof(titles)/sizeof(titles[0]); ++i) {

      boost::shared_ptr<ButtonComponent> new_button(new ButtonComponent);
      TextProperty normal(common->font, titles[i], MenuSize,
                          Fore, Back, true);
      TextProperty selected(common->font, titles[i], MenuSize,
                            Selected, Back, true);
      ButtonComponent::createButton(new_button, normal, selected, selected);
      if (new_button->getWidth() > max_width) {
        max_width = new_button->getWidth();
      }
      menu->addItem(new_button);
    }
    menu->setItemsOffset(0, MenuSize + 16);
    menu->setItemSelectWidth(max_width);
    menu->setSelected(0);

    set_SdlRect(&position, centerPosition(menu, 640/2), 480/4 + MenuOffset);
    menu->setPosition(&position);

    common->back_layer->push_front(common->back_label);

    set_SdlRect(&position,
		rightPosition(user_label, 640 - TextOffset), TextOffset);
    user_label->setPosition(&position);
  }

  void placeComponents(void) {
    common->front_layer->push_front(version_label);
    common->front_layer->push_front(title_label);
    common->front_layer->push_front(menu);
    if (! common->user_name.empty()) {
      common->front_layer->push_front(user_combobox);
    }
    //common->front_layer->push_front(user_label);
  }

  void removeComponents(void) {
    common->front_layer->remove(version_label);
    common->front_layer->remove(title_label);
    common->front_layer->remove(menu);
    common->front_layer->remove(user_combobox);
    //common->front_layer->remove(user_label);
  }

  void updateUserCombobox(void) {

    // R{{bNX̍č\z
    user_combobox->clearItems();
    // !!!

#if 0
    // [Üʒuݒ
    SDL_Rect position;
    set_SdlRect(&position,
                rightPosition(user_combobox, 640) - TextOffset, TextOffset);
    user_combobox->setPosition(&position);
#endif
  }
};


FirstMenu::FirstMenu(void) : pimpl(new pImpl) {
  pimpl->placeComponents();
}


FirstMenu::~FirstMenu(void) {
  pimpl->removeComponents();
}


void FirstMenu::run(void) {

  // y̍Đ
  if (pimpl->common->music) {
    pimpl->common->music->setNextMusic(BackMusic_1);
  }

  GuiManager* gui = pimpl->common->gui;
  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  while (quit == false) {

    int selected = pimpl->menu->getDecided();
    // !!! IɃ[U쐬Ɉړ悤ɂ
    if (0 || selected >= 0) {
      //selected = 2;

      // !!! Ƃ肠AŌ艹炷
      // !!! Is\ȍڂ肵ƂɉςȂAύX
      if (pimpl->common->music) {
        if (selected != 4) {
          pimpl->common->sound_effect->play(Decide);
        }
      }

      pimpl->removeComponents();
      if (selected == 0) {
        // ^CsOK
        PracticeMenu practice;
        practice.run();

      } else if (selected == 1) {
        // lbg[Nΐ
        NetworkMenu network;
        network.run();

      } else if (selected == 2) {
        // [U쐬
        UserMenu user;
        user.run();

      } else if (selected == 3) {
        // IvV
        OptionMenu option;
        option.run();

      } else if (selected == 4) {
        // Q[̏I
        return;
      }

      // j[đI\ɂ
      pimpl->placeComponents();
      pimpl->menu->releaseDecided();
    }

    input.update_all();
    gui->update();
    quit |= input.haveQuitEvent() | input.isReleased(SDLK_ESCAPE);
    delay(1);
  }
}
