#ifndef CYCLE_TIMER_H
#define CYCLE_TIMER_H

/*!
  \file
  \brief ^C}[

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>


namespace beego {
  class CycleTimer {
    CycleTimer(void);
    CycleTimer(const CycleTimer& rhs);
    CycleTimer& operator = (const CycleTimer& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      TimeExactly = true,
    };
    explicit CycleTimer(size_t cycle_msec, bool times_exactly = false);
    ~CycleTimer(void);

    void wait(void);
  };
};

#endif /* !CYCLE_TIMER_H */
