/*!
  \file
  \brief Component `

  \author Satofumi KAMIMURA

  $Id$

  \todo ComponentUtils Ȃǂɉׂ
  \todo addDrawSurface() ȂǂÃt@CɈړAH
*/

#include "Component.h"
#include "ComponentInterface.h"
#include "SurfaceInterface.h"
#include "SdlUtils.h"
#include "EvaluateArea.h"


// !!! area, position œnႤ̂C
void beego::updateDrawSurface(DrawSurface& draw_surface, Surface surface,
                              const SDL_Rect* area,
                              const SDL_Rect& position,
                              bool position_changed) {

  // !!! EvaluateArea łĒuAȁH

  // R|[lg̈ area ̋ʕ component_area ƂȂ
  draw_surface.surface = surface;
  if (! area) {
    // surface oړÎƂ́AŖ߂
    return;
  }

  draw_surface.mustDraw = true;
  draw_surface.position = position;
  draw_surface.position_changed = position_changed;
  draw_surface.is_changed = surface->isChanged();
  draw_surface.is_transparent = surface->isTransparent();
  set_SdlRect(&draw_surface.area, 0, 0, position.w, position.h);

  if (draw_surface.position.x < area->x) {
    int diff = area->x - draw_surface.position.x;
    draw_surface.position.x += diff;
    draw_surface.area.x = diff;
    draw_surface.area.w -= diff;
  }
  if (draw_surface.position.y < area->y) {
    int diff = area->y - draw_surface.position.y;
    draw_surface.position.y += diff;
    draw_surface.area.y = diff;
    draw_surface.area.h -= diff;
  }
  if (draw_surface.position.x + draw_surface.area.w > area->x + area->w) {
    draw_surface.area.w -=
      (draw_surface.position.x + draw_surface.area.w) - (area->x + area->w);
  }
  if (draw_surface.position.y + draw_surface.area.h > area->y + area->h) {
    draw_surface.area.h -=
      (draw_surface.position.y + draw_surface.area.h) - (area->y + area->h);
  }

  // `̈悪ȂȂAmustDraw  false ɂ
  // !!!
  // !!! ƂL̋LqAłӖ̂s
  // !!! CčČ
}


extern bool beego::isAppliedRect(const int x, const int y,
                                 const std::vector<SDL_Rect>& applied_rects) {

  for (std::vector<SDL_Rect>::const_iterator it = applied_rects.begin();
       it != applied_rects.end(); ++it) {

    // _̈ʒu͔ɗpς݂ false Ԃ
    if (isPointInside(x, y, *it)) {
      return false;
    }
  }

  // ǂ̗̈łgĂȂ΁Atrue Ԃ
  return true;
}


int beego::leftPosition(Component component, int left_position) {
  return left_position;
}


int beego::centerPosition(Component component, int center_position) {
  return center_position - static_cast<int>(component->getWidth()/2);
}


int beego::rightPosition(Component component, int right_position) {
  return right_position - static_cast<int>(component->getWidth());
}


int beego::topPosition(Component component, int top_position) {
  return top_position;
}


int beego::middlePosition(Component component, int middle_position) {
  return middle_position - static_cast<int>(component->getHeight()/2);
}


int beego::bottomPosition(Component component, int bottom_position) {
  return bottom_position - static_cast<int>(component->getHeight());
}
