#ifndef TEXT_SURFACE_H
#define TEXT_SURFACE_H

/*!
  \file
  \brief T[tFX

  \author Satofumi KAMIMURA

  $Id$
*/

#include "SurfaceInterface.h"
#include "GuiColors.h"
#include <memory>

namespace beego {
  class TtfResource;
  class SdlSurface;


  /*!
    \brief T[tFX
  */
  class TextSurface : public SurfaceInterface {
    TextSurface(const TextSurface& rhs);
    TextSurface& operator = (const TextSurface& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    TextSurface(TtfResource* font,
		const char* text, size_t size,
		Uint32 fore_color = beego::White,
		Uint32 back_color = beego::Black,
		bool transparent = false);
    TextSurface(TtfResource* font,
		const Uint16* text, size_t size,
		Uint32 fore_color = beego::White,
		Uint32 back_color = beego::Black,
		bool transparent = false);
    ~TextSurface(void);

    void draw(std::vector<SDL_Rect>& update_rects,
	      const SDL_Rect* pos, const SDL_Rect* area, size_t ticks);
    size_t getWidth(void);
    size_t getHeight(void);
    bool isChanged(void);
    bool isTransparent(void);

    // !!! ̂ƁASurfaceInterface ɒǉׂH
    void setAlpha(size_t percent);
  };
};

#endif /* !TEXT_SURFACE_H */
