/*!
  \file
  \brief ̃rT[tFX쐬

  \author Satofumi KAMIMURA

  $Id$

  \todo ͂ݏoărU邱Ƃ̂Cׂ
*/

#include "TextRubiSurface.h"
#include "TextFadeSurface.h"
#include "TextSurface.h"
#include "UtfString.h"

using namespace beego;


struct TextRubiSurface::pImpl {

  class RubiSurface : public FadeSurfacesInterface {
    FadeSurfaces surfaces;
    std::vector<size_t> ch_pos;
    //int left_edge;
    //int right_edge;
    //size_t total_width;
    size_t width;
    size_t height;
    int total_size;

    void createSurface(std::vector<Uint16>& rubi_add, size_t rubi_size,
		       TtfResource* font, int kanji_size,
		       Uint32 fore, Uint32 back, bool transparent,
		       int first_pos, int last_pos) {
      if (rubi_add.empty()) {
	return;
      }

      Uint16 rubi_ch[2] = { 0x0, 0x0 };
      size_t kanji_width = kanji_size * (last_pos - first_pos);
      size_t each_ch = kanji_width / rubi_add.size();
      if (each_ch < rubi_size) {
	each_ch = rubi_size;
      }
      int x_offset =
	kanji_width - (((rubi_add.size() - 1) * each_ch) + rubi_size);
      int index = 0;
      for (std::vector<Uint16>::iterator it = rubi_add.begin();
	   it != rubi_add.end(); ++it, ++index) {
	rubi_ch[0] = *it;

	boost::shared_ptr<TextSurface>
	  surface(new TextSurface(font, rubi_ch, rubi_size,
				  fore, back, transparent));

	int x = x_offset/2 + (each_ch * index);
	//fprintf(stderr, "%d, ", x);

#if 0
	// x  [菬ƂA̕g
	if (x < left_edge) {
	  left_edge = x;
	}

	// x + rubi_size ̕傫ƂAE̕g
	if (x > right_edge) {
	  right_edge = x;
	}
#endif

	ch_pos.push_back((100 * (kanji_size * first_pos + x)) / total_size);
	height = (height > surface->getWidth()) ? height : surface->getWidth();
	surfaces.push_back(surface);
      }
      rubi_add.clear();
    }

    void createRubiSurfaces(const Uint16* kana_text, size_t rubi_size,
			    TtfResource* font, const Uint16* kanji_text,
			    size_t size, Uint32 fore, Uint32 back,
			    bool transparent) {

      const Uint16* kanji_ch = kanji_text;
      const Uint16* kanji_first_ch = kanji_ch;
      const Uint16* rubi_ch = kana_text;

      // }b`Ȃ̉ӏT
      for (; *kanji_ch && *rubi_ch; ++kanji_ch) {
	if (*kanji_ch == *rubi_ch) {
	  ++rubi_ch;
	  ++kanji_first_ch;
	  continue;
	}

	// r͈̔͂T
	bool surface_created = false;
	for (const Uint16* kanji_end = kanji_ch + 1; *kanji_end; ++kanji_end) {
	  for (const Uint16* rubi_end = rubi_ch; *rubi_end; ++rubi_end) {
	    if (*rubi_end == *kanji_end) {
	      // T[tFX̍쐬
	      std::vector<Uint16> rubi_add;
	      size_t rubi_first = rubi_ch - kana_text;
	      size_t rubi_last = rubi_end - kana_text;
	      for (size_t i = rubi_first; i < rubi_last; ++i) {
		rubi_add.push_back(kana_text[i]);
	      }
	      size_t kanji_first = kanji_ch - kanji_text;
	      size_t kanji_last = kanji_end - kanji_text;

	      // ѕ菬΁Aɂ
	      if ((kanji_last - kanji_first) > rubi_add.size()) {
		continue;
	      }

	      rubi_ch += rubi_last - rubi_first;
	      kanji_first_ch = kanji_text + kanji_last;
	      createSurface(rubi_add, rubi_size, font, size, fore, back,
			    transparent, kanji_first, kanji_last);
	      kanji_ch += kanji_last - kanji_first -1;
	      surface_created = true;
	      break;
	    }
	  }
	  if (surface_created) {
	    break;
	  }
	}
      }
      if (*rubi_ch) {
	std::vector<Uint16> rubi_add;
	size_t n = ustrlen(rubi_ch);
	for (size_t i = 0; i < n; ++i) {
	  rubi_add.push_back(*(rubi_ch + i));
	}
	size_t kanji_first = kanji_first_ch - kanji_text;
	n = ustrlen(&kanji_text[kanji_first]);
	createSurface(rubi_add, rubi_size, font, size, fore, back,
		      transparent, kanji_first, kanji_first + n);
      }
    }

  public:
    RubiSurface(const Uint16* kana_text, size_t rubi_size,
		TtfResource* font, const Uint16* kanji_text,
		size_t size, Uint32 fore_color, Uint32 back_color,
		bool transparent)
    //: left_edge(0), right_edge(0), width(0), height(0) {
  : width(0), height(0) {

      total_size = ustrlen(kanji_text) * size;
      //total_width = total_size;
      width = total_size;

      // rT[tFXAшʒǔ
      createRubiSurfaces(kana_text, rubi_size, font, kanji_text, size,
			 fore_color, back_color, transparent);

      //width = (right_edge + rubi_size) - left_edge;

      // !!! Ƃ肠A 0 A 0 ɂĂ
      // !!! ̎œK؂́As
      if (height == 0) {
	width = 0;
      }
    }

    ~RubiSurface(void) {
    }

    FadeSurfaces& getSurfaces(void) {
      return surfaces;
    }

    int getPositionPercent(size_t index) {
      return ch_pos[index];
    }

    size_t getWidth(void) {
      return width;
    }

    size_t getHeight(void) {
      return height;
    }
  };

  enum {
    DefaultFadeNum = 3,
  };
  RubiSurface rubi_obj;
  TextFadeSurface text_fade;
  size_t width;
  size_t height;

  pImpl(const Uint16* kana_text, size_t rubi_size,
	TtfResource* font, const Uint16* kanji_text,
	size_t size, Uint32 fore_color, Uint32 back_color, bool transparent)
    : rubi_obj(kana_text, rubi_size, font, kanji_text, size,
	       fore_color, back_color, transparent),
      text_fade(&rubi_obj, size * DefaultFadeNum),
      width(rubi_obj.getWidth()), height(rubi_obj.getHeight()) {
    text_fade.setFadePercent(100);
  }
};


TextRubiSurface::TextRubiSurface(const Uint16* kana_text, size_t rubi_size,
				 TtfResource* font, const Uint16* kanji_text,
				 size_t size,
				 Uint32 fore_color, Uint32 back_color,
				 bool transparent)
  : pimpl(new pImpl(kana_text, rubi_size, font, kanji_text,
		    size, fore_color, back_color, transparent)) {
}


TextRubiSurface::~TextRubiSurface(void) {
}


void TextRubiSurface::draw(std::vector<SDL_Rect>& update_rects,
			   const SDL_Rect* pos, const SDL_Rect* area,
			   size_t ticks) {
  pimpl->text_fade.draw(update_rects, pos, area, ticks);
}


size_t TextRubiSurface::getWidth(void) {
  return pimpl->width;
}


size_t TextRubiSurface::getHeight(void) {
  return pimpl->height;
}


bool TextRubiSurface::isChanged(void) {
  return pimpl->text_fade.isChanged();
}


bool TextRubiSurface::isTransparent(void) {
  return pimpl->text_fade.isTransparent();
}


void TextRubiSurface::setFadeMode(FadeMode mode, size_t width) {
  pimpl->text_fade.setFadeMode(mode, width);
}


void TextRubiSurface::setFadePercent(size_t percent) {
  pimpl->text_fade.setFadePercent(percent);
}
