/*!
  \file
  \brief SDL ̉ʑ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "SdlVideo.h"
#include "SdlInit.h"
#include "LockGuard.h"
#include "LogManager.h"
#include <string>

using namespace beego;
using namespace SDL;


/*!
  \brief SdlVideo ̓NX

  \todo Windows ɂ SDL_Flip() ̕]s
  \todo Windows ɂ show(), hide() JԂہAshow() ̕Ԃl]
*/
struct SdlVideo::pImpl : private SdlInit {
  std::string error_message;
  SDL_mutex* mutex;
  bool initialized;
  std::string caption;

  enum {
    DefaultWidth = 640,
    DefaultHeight = 480,
    DefaultBpp = 0,		// ftHg[x𗘗p
  };
  size_t bpp;
  size_t now_w;
  size_t now_h;
  size_t next_w;
  size_t next_h;
  bool fullscreen;

  pImpl(void)
    : error_message("no error."),
      mutex(SDL_CreateMutex()), initialized(false), caption(""),
      bpp(DefaultBpp), now_w(0), now_h(0),
      next_w(DefaultWidth), next_h(DefaultHeight), fullscreen(false) {
  }

  ~pImpl(void) {
    SDL_DestroyMutex(mutex);
  }
};


SdlVideo::SdlVideo(void) : pimpl(new pImpl) {
}


SdlVideo::~SdlVideo(void) {
  hide();
}


const char* SdlVideo::what(void) {
  return pimpl->error_message.c_str();
}


void SdlVideo::setFullscreenMode(bool on) {
  pimpl->fullscreen = on;
}


SDL_Surface* SdlVideo::show(Uint32 mode) {
  LockGuard guard(pimpl->mutex);

  if (pimpl->initialized) {
    return SDL_GetVideoSurface();
  }

  if (SDL_InitSubSystem(SDL_INIT_VIDEO) < 0) {
    LogManager* log = LogManager::getObject();
    std::string message = "SdlVideo::show(): " + std::string(SDL_GetError());
    log->write(LogManager::Error, message.c_str());

    return NULL;
  }

  // T[tFXɊւLqȂ΁ASDL_HWSURFACE [hœ삳
  mode = (mode == 0) ? SDL_HWSURFACE : mode;
  mode |= pimpl->fullscreen ? SDL_FULLSCREEN : 0;

  // !!! Windows ŁASDL_Flip() ̕]s

  SDL_Surface* scr = SDL_SetVideoMode(pimpl->next_w, pimpl->next_h,
				      pimpl->bpp, mode);
  if (scr == NULL) {
    pimpl->error_message = SDL_GetError();
  }
  pimpl->initialized = (scr == NULL) ? false : true;

  if (pimpl->initialized != false) {
    pimpl->now_w = pimpl->next_w;
    pimpl->now_h = pimpl->next_h;
    SDL_WM_SetCaption(pimpl->caption.c_str(), NULL);
  }
  return scr;
}


void SdlVideo::hide(void) {
  if (pimpl->initialized) {
    LockGuard guard(pimpl->mutex);

    SDL_QuitSubSystem(SDL_INIT_VIDEO);
    pimpl->initialized = false;
    pimpl->now_w = 0;
    pimpl->now_h = 0;
  }
}


void SdlVideo::setCaption(const char* caption) {
  pimpl->caption = caption;
}


void SdlVideo::setWindowBpp(size_t bpp) {
  // !!! 
}


void SdlVideo::setWindowSize(size_t width, size_t height) {
  // !!! 
}


size_t SdlVideo::getWidth(void) {
  // !!! 
  return 0;
}


size_t SdlVideo::getHeight(void) {
  // !!! 
  return 0;
}
