/*!
  \file
  \brief ܂莚^CsǑʕ\

  \author Satofumi KAMIMURA

  $Id$

  \todo ʂtF[hȂ\
  \todo ʗ̃Ot\
  \todo Ot̕\ڂ̓[UɋL^Ă
*/

#include "ResultDrawer.h"
#include "ResultDrawer_uni.h"
#include "DrawsDefinition.h"
#include "CommonResources.h"
#include "TypingRecorder.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputHandler.h"
#include "InputEvent.h"
#include "InputReceiveComponent.h"
#include "TextSurface.h"
#include "TextFadeSurface.h"
#include "LabelComponent.h"
#include "LockGuard.h"
#include "SdlUtils.h"
#include "UtfString.h"

using namespace beego;


struct ResultDrawer::pImpl {
  TypingMode typing_mode;
  CommonResources* common;
  SDL_mutex* mutex;
  bool is_decided;
  InputEvent input_event;
  Surface title_surface;
  Component title_label;
  std::vector<Surface> name_surfaces;
  std::vector<Component> name_labels;
  std::vector<Surface> num_surfaces;
  std::vector<Component> num_labels;
  // !!! uPʁvƂpŒu
  std::vector<Surface> unit_surfaces;
  std::vector<Component> unit_labels;

  pImpl(TypingMode mode)
    : typing_mode(mode), common(CommonResources::getObject()),
      mutex(common->gui->getMutex()), is_decided(false),
      title_surface(new TextSurface(common->font, ResultDrawer_title,
				    WakaDrawSize, Fore, Back, true)),
      title_label(new LabelComponent(title_surface)) {
  }

  ~pImpl(void) {
    clearComponents();
  }

  void placeComponents(void) {
    LockGuard guard(mutex);
    common->front_layer->push_front(title_label);
    for (std::vector<Component>::iterator it = name_labels.begin();
	 it != name_labels.end(); ++it) {
      common->front_layer->push_front(*it);
    }
    for (std::vector<Component>::iterator it = num_labels.begin();
	 it != num_labels.end(); ++it) {
      common->front_layer->push_front(*it);
    }
    for (std::vector<Component>::iterator it = unit_labels.begin();
	 it != unit_labels.end(); ++it) {
      common->front_layer->push_front(*it);
    }
    common->front_layer->push_front(common->input_receiver);
  }

  void removeComponents(void) {
    LockGuard guard(mutex);
    common->front_layer->remove(title_label);
    for (std::vector<Component>::iterator it = name_labels.begin();
	 it != name_labels.end(); ++it) {
      common->front_layer->remove(*it);
    }
    for (std::vector<Component>::iterator it = num_labels.begin();
	 it != num_labels.end(); ++it) {
      common->front_layer->remove(*it);
    }
    for (std::vector<Component>::iterator it = unit_labels.begin();
	 it != unit_labels.end(); ++it) {
      common->front_layer->remove(*it);
    }
    common->front_layer->remove(common->input_receiver);
    common->input_receiver->clear();
  }

  void clearComponents(void) {
    name_surfaces.clear();
    name_labels.clear();
    num_surfaces.clear();
    num_labels.clear();
    unit_surfaces.clear();
    unit_labels.clear();
  }

  void updateComponent(void) {

    SDL_Rect position;
    set_SdlRect(&position, centerPosition(title_label, 640/2), 480/6);
    title_label->setPosition(&position);

    // a̐
    name_surfaces.push_back
      (static_cast<Surface>(new TextFadeSurface(common->font,
						ResultDrawer_num,
						MenuSize, Fore, Back, true)));
    name_labels.push_back
      (static_cast<Component>(new LabelComponent(name_surfaces.back())));

    // 
    char buffer[13];
    size_t waka_num = common->recorder->getWakaNum();
    sprintf(buffer, "%d", waka_num);
    std::vector<Uint16> num_text;
    ustrcat(num_text, buffer);
    num_surfaces.push_back
      (static_cast<Surface>(new TextFadeSurface(common->font, &num_text[0],
						MenuSize, Fore, Back, true)));
    num_labels.push_back
      (static_cast<Component>(new LabelComponent(num_surfaces.back())));
    unit_surfaces.push_back
      (static_cast<Surface>(new TextFadeSurface(common->font,
						ResultDrawer_syu,
						NormalSize,
						Fore, Back, true)));
    unit_labels.push_back
      (static_cast<Component>(new LabelComponent(unit_surfaces.back())));

    if (typing_mode == ShimonokuTyping) {
      // ^Cvx
      name_surfaces.push_back
	(static_cast<Surface>(new TextFadeSurface(common->font,
						  ResultDrawer_types,
						  MenuSize, Fore, Back,
						  true)));
      name_labels.push_back
	(static_cast<Component>(new LabelComponent(name_surfaces.back())));

      // /b
      num_text.clear();
      double typing_speed = common->recorder->getTypingSpeed();
      sprintf(buffer, "%.1f", typing_speed);
      ustrcat(num_text, buffer);
      num_surfaces.push_back
	(static_cast<Surface>(new TextFadeSurface(common->font, &num_text[0],
						  MenuSize, Fore, Back,
						  true)));
      num_labels.push_back
	(static_cast<Component>(new LabelComponent(num_surfaces.back())));
      unit_surfaces.push_back
	(static_cast<Surface>(new TextFadeSurface(common->font,
						  ResultDrawer_vel,
						  NormalSize,
						  Fore, Back, true)));
      unit_labels.push_back
	(static_cast<Component>(new LabelComponent(unit_surfaces.back())));
    }

    // ͊Jn܂ł̎
    name_surfaces.push_back
      (static_cast<Surface>(new TextFadeSurface(common->font,
						ResultDrawer_delay,
						MenuSize, Fore, Back, true)));
    name_labels.push_back
      (static_cast<Component>(new LabelComponent(name_surfaces.back())));

    // b
    num_text.clear();
    double delay_sec = common->recorder->getStartDelay();
    sprintf(buffer, "%.2f", delay_sec);
    ustrcat(num_text, buffer);
    num_surfaces.push_back
      (static_cast<Surface>(new TextFadeSurface(common->font, &num_text[0],
						MenuSize, Fore, Back, true)));
    num_labels.push_back
      (static_cast<Component>(new LabelComponent(num_surfaces.back())));
    unit_surfaces.push_back
      (static_cast<Surface>(new TextFadeSurface(common->font,
						ResultDrawer_sec,
						NormalSize,
						Fore, Back, true)));
    unit_labels.push_back
      (static_cast<Component>(new LabelComponent(unit_surfaces.back())));

    if (typing_mode == ShimonokuTyping) {
      // ^Cv
      name_surfaces.push_back
	(static_cast<Surface>(new TextFadeSurface(common->font,
						  ResultDrawer_miss,
						  MenuSize, Fore, Back,
						  true)));
      name_labels.push_back
	(static_cast<Component>(new LabelComponent(name_surfaces.back())));

      // 
      num_text.clear();
      size_t miss_types = common->recorder->getMissTypes();
      sprintf(buffer, "%d", miss_types);
      ustrcat(num_text, buffer);
      num_surfaces.push_back
	(static_cast<Surface>(new TextFadeSurface(common->font, &num_text[0],
						  MenuSize, Fore, Back,
						  true)));
      num_labels.push_back
	(static_cast<Component>(new LabelComponent(num_surfaces.back())));
      unit_surfaces.push_back
	(static_cast<Surface>(new TextFadeSurface(common->font,
						  ResultDrawer_times,
						  NormalSize,
						  Fore, Back, true)));
      unit_labels.push_back
	(static_cast<Component>(new LabelComponent(unit_surfaces.back())));
    }

    // ĉi̍ڈʒuɂ
    size_t unit_max_length = unit_labels.back()->getWidth();

    // R|[lg̈ʒuvZ
    position.y += ResultOffset - 10;
    SDL_Rect num_position;
    num_position.y = position.y;
    SDL_Rect unit_position;
    unit_position.y = position.y + (MenuSize - NormalSize);

    position.x = (640 - ResultWidth)/2;
    size_t num_pos_right = 640 - (640 - ResultWidth)/2 - unit_max_length;
    unit_position.x = num_pos_right;

    // ڂ̔zu
    for (std::vector<Component>::iterator it = name_labels.begin();
	 it != name_labels.end(); ++it) {
      position.y += ResultOffset;
      (*it)->setPosition(&position);
    }

    // l̔zu
    for (std::vector<Component>::iterator it = num_labels.begin();
	 it != num_labels.end(); ++it) {
      num_position.y += ResultOffset;
      num_position.x = rightPosition(*it, num_pos_right);
      (*it)->setPosition(&num_position);
    }

    // Pʂ̔zu
    for (std::vector<Component>::iterator it = unit_labels.begin();
	 it != unit_labels.end(); ++it) {
      unit_position.y += ResultOffset;
      (*it)->setPosition(&unit_position);
    }
  }
};


ResultDrawer::ResultDrawer(TypingMode mode) : pimpl(new pImpl(mode)) {
}


ResultDrawer::~ResultDrawer(void) {
}


void ResultDrawer::createResult(void) {

  // 
  pimpl->is_decided = false;

  // \錋ʂ̌vZ
  pimpl->common->recorder->evaluate();

  // R|[lg̐
  pimpl->clearComponents();
  pimpl->updateComponent();

  // R|[lg̔zu
  pimpl->placeComponents();
}


void ResultDrawer::drawResult(size_t ticks) {
  // !!!
  // !!! ticks ɏ]āA`s
}


void ResultDrawer::placeComponents(void) {
  pimpl->placeComponents();
}


void ResultDrawer::removeComponents(void) {
  pimpl->removeComponents();
}


bool ResultDrawer::keyPressed(void) {

  pimpl->common->input_receiver->updateInputEvent(pimpl->input_event);
  pimpl->is_decided |= InputEvent::isReleased(pimpl->input_event, SDLK_RETURN);

  return pimpl->is_decided;
}
