/*!
  \file
  \brief ^CsOK̃j[

  \author Satofumi KAMIMURA

  $Id$
*/

#include "PracticeMenu.h"
#include "PracticeMenu_uni.h"
#include "DrawsDefinition.h"
#include "SystemDefinition.h"
#include "ShimonokuPractice.h"
#include "KimarijiPractice.h"
#include "CommonResources.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputHandler.h"
#include "TextSurface.h"
#include "LabelComponent.h"
#include "MenuComponent.h"
#include "ButtonComponent.h"
#include "LockGuard.h"
#include "SdlUtils.h"
#include "Delay.h"

using namespace beego;


struct PracticeMenu::pImpl {
  CommonResources* common;
  SDL_mutex* mutex;
  TtfResource* font;
  Surface title_surface;
  Component title_label;
  boost::shared_ptr<MenuComponent> menu;

  pImpl(void)
    : common(CommonResources::getObject()), mutex(common->gui->getMutex()),
      font(common->font),
      title_surface(new TextSurface(font, PracticeMenu_title, TitleSize,
				    Fore, Back, true)),
      title_label(new LabelComponent(title_surface)), menu(new MenuComponent) {

    SDL_Rect position;
    // !!! 640, 480 ܂̒萔͒u
    set_SdlRect(&position, centerPosition(title_label, 640/2),
		middlePosition(title_label, 480/4));
    title_label->setPosition(&position);

    // j[̍ڂ쐬
    const Uint16 *titles[] = {
      PracticeMenu_shimonoku, PracticeMenu_kimariji, PracticeMenu_back,
    };
    for (size_t i = 0; i < sizeof(titles)/sizeof(titles[0]); ++i) {
      boost::shared_ptr<ButtonComponent> new_button(new ButtonComponent);
      ButtonComponent::createSimpleButton(new_button, common->font,
					  titles[i], MenuSize, Fore, Back,
					  MenuSize, Blue, Back, true);
      menu->addItem(new_button);
    }
    menu->setItemsOffset(0, MenuSize + 16);
    menu->setSelected(0);

    set_SdlRect(&position, centerPosition(menu, 640/2), 480/4 + MenuOffset);
    menu->setPosition(&position);
    //fprintf(stderr, "practice_menu: %d, %d\n", position.x, position.y);
  }

  void placeComponents(void) {
    LockGuard guard(mutex);
    common->front_layer->push_front(title_label);
    common->front_layer->push_front(menu);
  }

  void removeComponents(void) {
    LockGuard guard(mutex);
    common->front_layer->remove(title_label);
    common->front_layer->remove(menu);
  }
};


PracticeMenu::PracticeMenu(void) : pimpl(new pImpl) {
  pimpl->placeComponents();
}


PracticeMenu::~PracticeMenu(void) {
  pimpl->removeComponents();
}


void PracticeMenu::run(void) {

  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  while (quit == false) {

    int selected = pimpl->menu->getDecided();
    if (selected >= 0) {
      pimpl->removeComponents();

      if (selected == 0) {
	// ̋^CsO
	ShimonokuPractice shimonoku_practice;
	shimonoku_practice.run();

      } else if (selected == 1) {
	// ܂莚^CsO
	KimarijiPractice kimariji_practice;
	kimariji_practice.run();

      } else if (selected == 2) {
	// ߂
	quit |= true;
      }

      // j[đI\ɂ
      pimpl->placeComponents();
      LockGuard guard(pimpl->mutex);
      pimpl->menu->releaseDecided();
    }

    input.update_all();
    quit |= input.isReleased(SDLK_ESCAPE);
    if (input.haveQuitEvent()) {
      pimpl->common->front_layer->disable();
      quit |= true;
    }
    delay(1);
  }
}
