#ifndef MUSIC_MANAGER_H
#define MUSIC_MANAGER_H

/*!
  \file
  \brief wiȂ̊Ǘ

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>


namespace beego {
  /*!
    \brief wiȂ̊ǗNX
  */
  class MusicManager {
    MusicManager(const MusicManager& rhs);
    MusicManager& operator = (const MusicManager& rhs);

    struct pImpl;
    //const std::auto_ptr<pImpl> pimpl;
    // !!! shared_ptr ɂׂȂ̂H
    pImpl* pimpl;

  public:
    enum {
      Infinity = -1,		//!< ̍Đ
    };
    MusicManager(void);
    ~MusicManager(void);

    /*!
      \brief ς݂Ԃ

      \retval true ς
      \retval false 
    */
    bool isInitialized(void);

    /*!
      \brief y̓o^

      \param music_id [i] o^ ID ԍ
      \param file_path [i] yt@ĈpX

      \retval true o^
      \retval false o^s

      \attention  music_id w肳ꂽꍇAŌ̎w肪LɂȂ
    */

    bool registerMusic(int music_id, const char* file_path);

    /*!
      \brief y̓o^폜

      \param music_id [i] 폜 ID ԍ
    */
    void unregisterMusic(int music_id);

    /*!
      \brief ʂ̊ݒ

      \param percent [i] y̏o̓{[ݒu [%]
    */
    void updateVolume(size_t percent);

    /*!
      \brief Ȃ̐؂ւ

      \param next_music_id [i] ɍĐ鉹y ID ԍ
      \param play_times [i] Đ (0 ōĐ~)
    */
    void setNextMusic(int next_music_id, int play_times = Infinity);

    /*!
      \brief Ȃ̒~

      \param fade_out_msec [i] tF[hAEg [msec]
    */
    void stop(size_t fade_out_msec = 0);

    /*!
      \brief tF[hCݒ

      setNextMusic() ɗp

      \param effect_msec [i] tF[hC [msec]
    */
    void setFadeInEffect(size_t effect_msec);

    /*!
      \brief tF[hAEgݒ

      setNextMusic(), stop() ɗp

      \param effect_msec [i] tF[hAEg [msec]
    */
    void setFadeOutEffect(size_t effect_msec);

    /*!
      \brief ݍĐ̉yԍw

      \return Đ̉yԍ

      \attention ĐoȂꍇA߂l͖
    */
    int getCurrentMusicId(void);

    /*!
      \brief ĐԂ

      \retval true Đ
      \retval false ~
    */
    bool nowPlaying(void);
  };
};

#endif /* !MUSIC_MANAGER_H */
