/*!
  \file
  \brief C[

  \author Satofumi KAMIMURA

  $Id$
*/

#include "Layer.h"
#include "ComponentInterface.h"
#include "LayerManager.h"

using namespace beego;


/*!
  \brief Layer ̓NX
*/
struct Layer::pImpl {
  ComponentList component_list;
  LayerManager* manager;
  bool enable;

  pImpl(void) : manager(NULL), enable(true) {
  }

  void positionTouch(Component component) {
    SDL_Rect position;
    component->getPosition(&position);
    component->setPosition(&position);
  }
};


Layer::Layer(void) : pimpl(new pImpl) {
}


Layer::~Layer(void) {
}


void Layer::addComponentList(ComponentList& components) const {

  for (ComponentList::iterator it = pimpl->component_list.begin();
       it != pimpl->component_list.end(); ++it) {
    components.push_back(*it);
  }
}


void Layer::addSurfaceList(SurfaceList& surfaces, const SDL_Rect* area) {

  // ێĂS Component ɑ΂ addSurfaceList() Ăяo
  for (ComponentList::iterator it = pimpl->component_list.begin();
       it != pimpl->component_list.end(); ++it) {

    (*it)->addSurfaceList(surfaces, area);
  }
}


/*!
  \attention VKɑ΂Ė
*/
void Layer::push_front(Component component) {
  if (! pimpl->enable) {
    return;
  }

  pimpl->component_list.push_front(component);

  // ʒuXVAĕ`𑣂
  // !!! ܂ǂȂ
  pimpl->positionTouch(component);
}


/*!
  \attention VKɑ΂Ė
*/
void Layer::push_back(Component component) {
  if (! pimpl->enable) {
    return;
  }

  pimpl->component_list.push_back(component);

  // ʒuXVAĕ`𑣂
  // !!! ܂ǂȂ
  pimpl->positionTouch(component);
}


/*!
  \attention VKɑ΂Ė
*/
void Layer::insert(const Component dst, Component component) {
  if (! pimpl->enable) {
    return;
  }

  ComponentList::iterator it = find(pimpl->component_list.begin(),
				    pimpl->component_list.end(), dst);
  if (it != pimpl->component_list.end()) {
    pimpl->component_list.insert(it, component);
  }

  // ʒuXVAĕ`𑣂
  // !!! ܂ǂȂ
  pimpl->positionTouch(component);
}


void Layer::remove(Component component) {
  if (! pimpl->enable) {
    return;
  }

  ComponentList::iterator it = find(pimpl->component_list.begin(),
				    pimpl->component_list.end(), component);
  if (it != pimpl->component_list.end()) {
    SDL_Rect removed_rect;
    (*it)->getPosition(&removed_rect);

    // !!! ̂肩AVK
    // !!! 폜֐Ăяoׂ
    SurfaceList remove_list;
    (*it)->addSurfaceList(remove_list, &removed_rect);
    //pimpl->manager->removeSurface(remove_list, &removed_rect);
    pimpl->manager->removeSurface(remove_list);
#if 0
    for (SurfaceList::iterator rm_it = remove_list.begin();
	 rm_it != remove_list.end(); ++rm_it) {
      //for (SurfaceList::reverse_iterator rm_it = remove_list.rbegin();
      //rm_it != remove_list.rend(); ++rm_it) {
      //fprintf(stderr, "removed_rect: %d, %d, %d, %d\n", removed_rect.x, removed_rect.y, removed_rect.w, removed_rect.h);
      pimpl->manager->removeSurface(*rm_it, &removed_rect);
    }
#endif

    // !!! Ƃ肠A폜߂Ă݂܂
    // !!! 폜ĂȂƂ͎vĂ...
    pimpl->component_list.erase(it);
    // !!! L폜ƁAwʂ̃T[tFXcBs
  }
}


void Layer::registerManager(LayerManager* obj) {
  pimpl->manager = obj;
}


void Layer::enable(void) {
  pimpl->enable = true;
}


void Layer::disable(void) {
  pimpl->enable = false;
}
