#ifndef INPUT_EVENT_H
#define INPUT_EVENT_H

/*!
  \file
  \brief ̓Cxg̊Ǘ

  \author Satofumi KAMIMURA

  $Id$
*/

#include <SDL.h>
#include <vector>


namespace beego {
  class InputEvent {
  public:
    int mx;
    int my;
    bool mouse_moved;
    int wheels;

    bool left_clicked;
    bool left_released;

    class InputKey {
    public:
      SDLKey sym;
      SDLMod mod;
      Uint16 unicode;

      InputKey(SDLKey sym_value, SDLMod mod_value, Uint16 unicode_value)
	: sym(sym_value), mod(mod_value), unicode(unicode_value) {
      }
    };
    typedef std::vector<InputKey> InputKeys;
    typedef std::vector<SDLKey> SdlKeys;
    InputKeys key_pressed;
    SdlKeys key_released;

    InputEvent(void)
      : mx(0), my(0), mouse_moved(false), wheels(0),
	left_clicked(false), left_released(false) {
    }

    static bool isPressed(const InputEvent& event, SDLKey key);
    static bool isReleased(const InputEvent& event, SDLKey key);
  };
};

#endif /* !INPUT_EVENT_H */
