/*!
  \file
  \brief Ñj[

  \author Satofumi KAMIMURA

  $Id$

  \todo IĂ鍀ڂɁAACRt
  \todo [UI\ɂ
  \todo |bvAbvŃj[ڂ̐s
  \todo I𒆂̃[U̕\
  \todo R{{bNXŃ[U\
  \todo run() ̏dȂƂ
*/

#include "FirstMenu.h"
#include "FirstMenu_uni.h"
#include "hyakutyping.h"
#include "DrawsDefinition.h"
#include "CommonResources.h"
#include "PracticeMenu.h"
#include "NetworkMenu.h"
#include "OptionMenu.h"
#include "GuiManager.h"
#include "Layer.h"
#include "TextSurface.h"
#include "LabelComponent.h"
#include "ButtonComponent.h"
#include "MenuComponent.h"
#include "InputHandler.h"
#include "LockGuard.h"
#include "SdlUtils.h"
#include "Delay.h"

using namespace beego;


struct FirstMenu::pImpl {
  CommonResources* common;
  SDL_mutex* mutex;
  TtfResource* font;
  Surface title_surface;
  Component title_label;
  boost::shared_ptr<MenuComponent> menu;
  Surface version_surface;
  Component version_label;

  pImpl(void)
    : common(CommonResources::getObject()), mutex(common->gui->getMutex()),
      title_surface(new TextSurface(common->font, FirstMenu_title, TitleSize,
				    Fore, Back, true)),
      title_label(new LabelComponent(title_surface)), menu(new MenuComponent),
      version_surface(new TextSurface(common->font, VersionText, NormalSize,
				      Fore, Back, true)),
      version_label(new LabelComponent(version_surface)) {

    // o[Ẅʒuݒ
    SDL_Rect position;
    set_SdlRect(&position, TextOffset, TextOffset);
    version_label->setPosition(&position);

    // ^Cg̈ʒuݒ
    set_SdlRect(&position, centerPosition(title_label, 640/2),
		middlePosition(title_label, 480/4));
    title_label->setPosition(&position);

    // j[̍ڂ쐬
    const Uint16 *titles[] = {
      FirstMenu_practice, FirstMenu_network, FirstMenu_option, FirstMenu_quit,
    };
    for (size_t i = 0; i < sizeof(titles)/sizeof(titles[0]); ++i) {
      boost::shared_ptr<ButtonComponent> new_button(new ButtonComponent);
      ButtonComponent::createSimpleButton(new_button, common->font,
					  titles[i], MenuSize, Fore, Back,
					  MenuSize, Selected, Back, true);
      menu->addItem(new_button);
    }
    menu->setItemsOffset(0, MenuSize + 16);
    menu->setSelected(0);

    set_SdlRect(&position, centerPosition(menu, 640/2),	480/4 + MenuOffset);
    menu->setPosition(&position);
    //fprintf(stderr, "first_menu: %d, %d\n", position.x, position.y);

    LockGuard guard(mutex);
    // I܂Ŕzu
    // !!! ̂肪AGuiManager łȂȂ̂ȁH
    common->back_layer->push_front(common->back_label);
  }

  void placeComponents(void) {
    LockGuard guard(mutex);
    common->front_layer->push_front(version_label);
    common->front_layer->push_front(title_label);
    common->front_layer->push_front(menu);
  }

  void removeComponents(void) {
    LockGuard guard(mutex);
    common->front_layer->remove(version_label);
    common->front_layer->remove(title_label);
    common->front_layer->remove(menu);
  }
};


FirstMenu::FirstMenu(void) : pimpl(new pImpl) {
  pimpl->placeComponents();
}


FirstMenu::~FirstMenu(void) {
  pimpl->removeComponents();
}


void FirstMenu::run(void) {

  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  while (quit == false) {

    int selected = pimpl->menu->getDecided();
    if (selected >= 0) {
      pimpl->removeComponents();

      if (selected == 0) {
	// ^CsOK
	PracticeMenu practice;
	practice.run();

      } else if (selected == 1) {
	// lbg[Nΐ
	NetworkMenu network;
	network.run();

      } else if (selected == 2) {
	// IvV
	OptionMenu option;
	option.run();

      } else if (selected == 3) {
	// Q[̏I
	return;
      }

      // j[đI\ɂ
      pimpl->placeComponents();
      LockGuard guard(pimpl->mutex);
      pimpl->menu->releaseDecided();
    }

    input.update_all();
    quit |= input.haveQuitEvent() | input.isReleased(SDLK_ESCAPE);
    delay(1);
  }
}
